package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.entity.ContactEmailEntity;
import me.proton.core.contact.data.local.db.entity.relation.ContactEmailWithLabelsRelation;
import me.proton.core.contact.domain.entity.ContactEmailId;
import me.proton.core.contact.domain.entity.ContactId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContactEmailDao_Impl extends ContactEmailDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContactEmailEntity> __insertionAdapterOfContactEmailEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final ContactConverters __contactConverters = new ContactConverters();

  private final EntityDeletionOrUpdateAdapter<ContactEmailEntity> __deletionAdapterOfContactEmailEntity;

  private final EntityDeletionOrUpdateAdapter<ContactEmailEntity> __updateAdapterOfContactEmailEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllContactsEmails;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllContactsEmails_1;

  public ContactEmailDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContactEmailEntity = new EntityInsertionAdapter<ContactEmailEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `ContactEmailEntity` (`userId`,`contactEmailId`,`name`,`email`,`defaults`,`order`,`contactId`,`canonicalEmail`,`isProton`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContactEmailEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __contactConverters.fromContactEmailIdToString(value.getContactEmailId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getEmail() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getEmail());
        }
        stmt.bindLong(5, value.getDefaults());
        stmt.bindLong(6, value.getOrder());
        final String _tmp_2 = __contactConverters.fromContactIdToString(value.getContactId());
        if (_tmp_2 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, _tmp_2);
        }
        if (value.getCanonicalEmail() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getCanonicalEmail());
        }
        if (value.isProton() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindLong(9, value.isProton());
        }
      }
    };
    this.__deletionAdapterOfContactEmailEntity = new EntityDeletionOrUpdateAdapter<ContactEmailEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `ContactEmailEntity` WHERE `contactEmailId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContactEmailEntity value) {
        final String _tmp = __contactConverters.fromContactEmailIdToString(value.getContactEmailId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfContactEmailEntity = new EntityDeletionOrUpdateAdapter<ContactEmailEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContactEmailEntity` SET `userId` = ?,`contactEmailId` = ?,`name` = ?,`email` = ?,`defaults` = ?,`order` = ?,`contactId` = ?,`canonicalEmail` = ?,`isProton` = ? WHERE `contactEmailId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContactEmailEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __contactConverters.fromContactEmailIdToString(value.getContactEmailId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getEmail() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getEmail());
        }
        stmt.bindLong(5, value.getDefaults());
        stmt.bindLong(6, value.getOrder());
        final String _tmp_2 = __contactConverters.fromContactIdToString(value.getContactId());
        if (_tmp_2 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, _tmp_2);
        }
        if (value.getCanonicalEmail() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getCanonicalEmail());
        }
        if (value.isProton() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindLong(9, value.isProton());
        }
        final String _tmp_3 = __contactConverters.fromContactEmailIdToString(value.getContactEmailId());
        if (_tmp_3 == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, _tmp_3);
        }
      }
    };
    this.__preparedStmtOfDeleteAllContactsEmails = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM ContactEmailEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAllContactsEmails_1 = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM ContactEmailEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final ContactEmailEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContactEmailEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final ContactEmailEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfContactEmailEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final ContactEmailEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfContactEmailEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final ContactEmailEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteContactsEmails(final ContactEmailId[] contactEmailIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailDao_Impl.super.deleteContactsEmails(contactEmailIds, __cont), $completion);
  }

  @Override
  public Object deleteAllContactsEmails(final ContactId[] contactIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailDao_Impl.super.deleteAllContactsEmails(contactIds, __cont), $completion);
  }

  @Override
  public Object deleteAllContactsEmails(final UserId userId,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllContactsEmails.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAllContactsEmails.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAllContactsEmails(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllContactsEmails_1.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAllContactsEmails_1.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<List<ContactEmailWithLabelsRelation>> observeAllContactsEmails(final UserId userId) {
    final String _sql = "SELECT * FROM ContactEmailEntity WHERE userId = ? ORDER BY `order`, name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[]{"ContactEmailLabelEntity","ContactEmailEntity"}, new Callable<List<ContactEmailWithLabelsRelation>>() {
      @Override
      public List<ContactEmailWithLabelsRelation> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfContactEmailId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactEmailId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfDefaults = CursorUtil.getColumnIndexOrThrow(_cursor, "defaults");
            final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
            final int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactId");
            final int _cursorIndexOfCanonicalEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "canonicalEmail");
            final int _cursorIndexOfIsProton = CursorUtil.getColumnIndexOrThrow(_cursor, "isProton");
            final ArrayMap<String, ArrayList<String>> _collectionLabelIds = new ArrayMap<String, ArrayList<String>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
              ArrayList<String> _tmpLabelIdsCollection = _collectionLabelIds.get(_tmpKey);
              if (_tmpLabelIdsCollection == null) {
                _tmpLabelIdsCollection = new ArrayList<String>();
                _collectionLabelIds.put(_tmpKey, _tmpLabelIdsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
            final List<ContactEmailWithLabelsRelation> _result = new ArrayList<ContactEmailWithLabelsRelation>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final ContactEmailWithLabelsRelation _item;
              final ContactEmailEntity _tmpContactEmail;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactEmailId) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDefaults) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfCanonicalEmail) && _cursor.isNull(_cursorIndexOfIsProton))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final ContactEmailId _tmpContactEmailId;
                final String _tmp_2;
                if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                  _tmp_2 = null;
                } else {
                  _tmp_2 = _cursor.getString(_cursorIndexOfContactEmailId);
                }
                _tmpContactEmailId = __contactConverters.fromStringToContactEmailId(_tmp_2);
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                final String _tmpEmail;
                if (_cursor.isNull(_cursorIndexOfEmail)) {
                  _tmpEmail = null;
                } else {
                  _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                }
                final int _tmpDefaults;
                _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
                final int _tmpOrder;
                _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                final ContactId _tmpContactId;
                final String _tmp_3;
                if (_cursor.isNull(_cursorIndexOfContactId)) {
                  _tmp_3 = null;
                } else {
                  _tmp_3 = _cursor.getString(_cursorIndexOfContactId);
                }
                _tmpContactId = __contactConverters.fromStringToContactId(_tmp_3);
                final String _tmpCanonicalEmail;
                if (_cursor.isNull(_cursorIndexOfCanonicalEmail)) {
                  _tmpCanonicalEmail = null;
                } else {
                  _tmpCanonicalEmail = _cursor.getString(_cursorIndexOfCanonicalEmail);
                }
                final Integer _tmpIsProton;
                if (_cursor.isNull(_cursorIndexOfIsProton)) {
                  _tmpIsProton = null;
                } else {
                  _tmpIsProton = _cursor.getInt(_cursorIndexOfIsProton);
                }
                _tmpContactEmail = new ContactEmailEntity(_tmpUserId,_tmpContactEmailId,_tmpName,_tmpEmail,_tmpDefaults,_tmpOrder,_tmpContactId,_tmpCanonicalEmail,_tmpIsProton);
              }  else  {
                _tmpContactEmail = null;
              }
              ArrayList<String> _tmpLabelIdsCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactEmailId);
              _tmpLabelIdsCollection_1 = _collectionLabelIds.get(_tmpKey_1);
              if (_tmpLabelIdsCollection_1 == null) {
                _tmpLabelIdsCollection_1 = new ArrayList<String>();
              }
              _item = new ContactEmailWithLabelsRelation(_tmpContactEmail,_tmpLabelIdsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<ContactEmailWithLabelsRelation>> observeAllContactsEmails(
      final ContactId contactId) {
    final String _sql = "SELECT * FROM ContactEmailEntity WHERE contactId = ? ORDER BY `order`, name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __contactConverters.fromContactIdToString(contactId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[]{"ContactEmailLabelEntity","ContactEmailEntity"}, new Callable<List<ContactEmailWithLabelsRelation>>() {
      @Override
      public List<ContactEmailWithLabelsRelation> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfContactEmailId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactEmailId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfDefaults = CursorUtil.getColumnIndexOrThrow(_cursor, "defaults");
            final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
            final int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactId");
            final int _cursorIndexOfCanonicalEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "canonicalEmail");
            final int _cursorIndexOfIsProton = CursorUtil.getColumnIndexOrThrow(_cursor, "isProton");
            final ArrayMap<String, ArrayList<String>> _collectionLabelIds = new ArrayMap<String, ArrayList<String>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
              ArrayList<String> _tmpLabelIdsCollection = _collectionLabelIds.get(_tmpKey);
              if (_tmpLabelIdsCollection == null) {
                _tmpLabelIdsCollection = new ArrayList<String>();
                _collectionLabelIds.put(_tmpKey, _tmpLabelIdsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
            final List<ContactEmailWithLabelsRelation> _result = new ArrayList<ContactEmailWithLabelsRelation>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final ContactEmailWithLabelsRelation _item;
              final ContactEmailEntity _tmpContactEmail;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactEmailId) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDefaults) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfCanonicalEmail) && _cursor.isNull(_cursorIndexOfIsProton))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final ContactEmailId _tmpContactEmailId;
                final String _tmp_2;
                if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                  _tmp_2 = null;
                } else {
                  _tmp_2 = _cursor.getString(_cursorIndexOfContactEmailId);
                }
                _tmpContactEmailId = __contactConverters.fromStringToContactEmailId(_tmp_2);
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                final String _tmpEmail;
                if (_cursor.isNull(_cursorIndexOfEmail)) {
                  _tmpEmail = null;
                } else {
                  _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                }
                final int _tmpDefaults;
                _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
                final int _tmpOrder;
                _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                final ContactId _tmpContactId;
                final String _tmp_3;
                if (_cursor.isNull(_cursorIndexOfContactId)) {
                  _tmp_3 = null;
                } else {
                  _tmp_3 = _cursor.getString(_cursorIndexOfContactId);
                }
                _tmpContactId = __contactConverters.fromStringToContactId(_tmp_3);
                final String _tmpCanonicalEmail;
                if (_cursor.isNull(_cursorIndexOfCanonicalEmail)) {
                  _tmpCanonicalEmail = null;
                } else {
                  _tmpCanonicalEmail = _cursor.getString(_cursorIndexOfCanonicalEmail);
                }
                final Integer _tmpIsProton;
                if (_cursor.isNull(_cursorIndexOfIsProton)) {
                  _tmpIsProton = null;
                } else {
                  _tmpIsProton = _cursor.getInt(_cursorIndexOfIsProton);
                }
                _tmpContactEmail = new ContactEmailEntity(_tmpUserId,_tmpContactEmailId,_tmpName,_tmpEmail,_tmpDefaults,_tmpOrder,_tmpContactId,_tmpCanonicalEmail,_tmpIsProton);
              }  else  {
                _tmpContactEmail = null;
              }
              ArrayList<String> _tmpLabelIdsCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactEmailId);
              _tmpLabelIdsCollection_1 = _collectionLabelIds.get(_tmpKey_1);
              if (_tmpLabelIdsCollection_1 == null) {
                _tmpLabelIdsCollection_1 = new ArrayList<String>();
              }
              _item = new ContactEmailWithLabelsRelation(_tmpContactEmail,_tmpLabelIdsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  protected Object deleteContactsEmailsSingleBatch(final ContactEmailId[] contactEmailIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEmailEntity WHERE contactId IN (");
        final int _inputSize = contactEmailIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactEmailId _item : contactEmailIds) {
          final String _tmp = __contactConverters.fromContactEmailIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  protected Object deleteAllContactsEmailsSingleBatch(final ContactId[] contactIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEmailEntity WHERE contactId IN (");
        final int _inputSize = contactIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactId _item : contactIds) {
          final String _tmp = __contactConverters.fromContactIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipContactEmailLabelEntityAsjavaLangString(
      final ArrayMap<String, ArrayList<String>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<String>> _tmpInnerMap = new ArrayMap<String, ArrayList<String>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<String>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `labelId`,`contactEmailId` FROM `ContactEmailLabelEntity` WHERE `contactEmailId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "contactEmailId");
      if (_itemKeyIndex == -1) {
        return;
      }
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<String> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final String _item_1;
          if (_cursor.isNull(0)) {
            _item_1 = null;
          } else {
            _item_1 = _cursor.getString(0);
          }
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
