package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.entity.ContactCardEntity;
import me.proton.core.contact.data.local.db.entity.ContactEmailEntity;
import me.proton.core.contact.data.local.db.entity.ContactEntity;
import me.proton.core.contact.data.local.db.entity.relation.ContactEmailWithLabelsRelation;
import me.proton.core.contact.data.local.db.entity.relation.ContactWithMailsAndCardsRelation;
import me.proton.core.contact.data.local.db.entity.relation.ContactWithMailsRelation;
import me.proton.core.contact.domain.entity.ContactEmailId;
import me.proton.core.contact.domain.entity.ContactId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContactDao_Impl extends ContactDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContactEntity> __insertionAdapterOfContactEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final ContactConverters __contactConverters = new ContactConverters();

  private final EntityDeletionOrUpdateAdapter<ContactEntity> __deletionAdapterOfContactEntity;

  private final EntityDeletionOrUpdateAdapter<ContactEntity> __updateAdapterOfContactEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllContacts;

  public ContactDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContactEntity = new EntityInsertionAdapter<ContactEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `ContactEntity` (`userId`,`contactId`,`name`) VALUES (?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContactEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __contactConverters.fromContactIdToString(value.getContactId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
      }
    };
    this.__deletionAdapterOfContactEntity = new EntityDeletionOrUpdateAdapter<ContactEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `ContactEntity` WHERE `contactId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContactEntity value) {
        final String _tmp = __contactConverters.fromContactIdToString(value.getContactId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfContactEntity = new EntityDeletionOrUpdateAdapter<ContactEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContactEntity` SET `userId` = ?,`contactId` = ?,`name` = ? WHERE `contactId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContactEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __contactConverters.fromContactIdToString(value.getContactId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        final String _tmp_2 = __contactConverters.fromContactIdToString(value.getContactId());
        if (_tmp_2 == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, _tmp_2);
        }
      }
    };
    this.__preparedStmtOfDeleteAllContacts = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM ContactEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final ContactEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContactEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final ContactEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfContactEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final ContactEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfContactEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final ContactEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteContacts(final ContactId[] contactIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactDao_Impl.super.deleteContacts(contactIds, __cont), $completion);
  }

  @Override
  public Object deleteAllContacts(final UserId[] userIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactDao_Impl.super.deleteAllContacts(userIds, __cont), $completion);
  }

  @Override
  public Object deleteAllContacts(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllContacts.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAllContacts.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<ContactWithMailsAndCardsRelation> observeContact(final ContactId contactId) {
    final String _sql = "SELECT * FROM ContactEntity WHERE contactId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __contactConverters.fromContactIdToString(contactId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[]{"ContactCardEntity","ContactEmailLabelEntity","ContactEmailEntity","ContactEntity"}, new Callable<ContactWithMailsAndCardsRelation>() {
      @Override
      public ContactWithMailsAndCardsRelation call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final ArrayMap<String, ArrayList<ContactCardEntity>> _collectionCards = new ArrayMap<String, ArrayList<ContactCardEntity>>();
            final ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>> _collectionEmails = new ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfContactId);
              ArrayList<ContactCardEntity> _tmpCardsCollection = _collectionCards.get(_tmpKey);
              if (_tmpCardsCollection == null) {
                _tmpCardsCollection = new ArrayList<ContactCardEntity>();
                _collectionCards.put(_tmpKey, _tmpCardsCollection);
              }
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactId);
              ArrayList<ContactEmailWithLabelsRelation> _tmpEmailsCollection = _collectionEmails.get(_tmpKey_1);
              if (_tmpEmailsCollection == null) {
                _tmpEmailsCollection = new ArrayList<ContactEmailWithLabelsRelation>();
                _collectionEmails.put(_tmpKey_1, _tmpEmailsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity(_collectionCards);
            __fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation(_collectionEmails);
            final ContactWithMailsAndCardsRelation _result;
            if(_cursor.moveToFirst()) {
              final ContactEntity _tmpContact;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfName))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final ContactId _tmpContactId;
                final String _tmp_2;
                if (_cursor.isNull(_cursorIndexOfContactId)) {
                  _tmp_2 = null;
                } else {
                  _tmp_2 = _cursor.getString(_cursorIndexOfContactId);
                }
                _tmpContactId = __contactConverters.fromStringToContactId(_tmp_2);
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpContact = new ContactEntity(_tmpUserId,_tmpContactId,_tmpName);
              }  else  {
                _tmpContact = null;
              }
              ArrayList<ContactCardEntity> _tmpCardsCollection_1 = null;
              final String _tmpKey_2 = _cursor.getString(_cursorIndexOfContactId);
              _tmpCardsCollection_1 = _collectionCards.get(_tmpKey_2);
              if (_tmpCardsCollection_1 == null) {
                _tmpCardsCollection_1 = new ArrayList<ContactCardEntity>();
              }
              ArrayList<ContactEmailWithLabelsRelation> _tmpEmailsCollection_1 = null;
              final String _tmpKey_3 = _cursor.getString(_cursorIndexOfContactId);
              _tmpEmailsCollection_1 = _collectionEmails.get(_tmpKey_3);
              if (_tmpEmailsCollection_1 == null) {
                _tmpEmailsCollection_1 = new ArrayList<ContactEmailWithLabelsRelation>();
              }
              _result = new ContactWithMailsAndCardsRelation(_tmpContact,_tmpCardsCollection_1,_tmpEmailsCollection_1);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<ContactWithMailsRelation>> observeAllContacts(final UserId userId) {
    final String _sql = "SELECT * FROM ContactEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[]{"ContactEmailLabelEntity","ContactEmailEntity","ContactEntity"}, new Callable<List<ContactWithMailsRelation>>() {
      @Override
      public List<ContactWithMailsRelation> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>> _collectionEmails = new ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfContactId);
              ArrayList<ContactEmailWithLabelsRelation> _tmpEmailsCollection = _collectionEmails.get(_tmpKey);
              if (_tmpEmailsCollection == null) {
                _tmpEmailsCollection = new ArrayList<ContactEmailWithLabelsRelation>();
                _collectionEmails.put(_tmpKey, _tmpEmailsCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation(_collectionEmails);
            final List<ContactWithMailsRelation> _result = new ArrayList<ContactWithMailsRelation>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final ContactWithMailsRelation _item;
              final ContactEntity _tmpContact;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfName))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final ContactId _tmpContactId;
                final String _tmp_2;
                if (_cursor.isNull(_cursorIndexOfContactId)) {
                  _tmp_2 = null;
                } else {
                  _tmp_2 = _cursor.getString(_cursorIndexOfContactId);
                }
                _tmpContactId = __contactConverters.fromStringToContactId(_tmp_2);
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                _tmpContact = new ContactEntity(_tmpUserId,_tmpContactId,_tmpName);
              }  else  {
                _tmpContact = null;
              }
              ArrayList<ContactEmailWithLabelsRelation> _tmpEmailsCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfContactId);
              _tmpEmailsCollection_1 = _collectionEmails.get(_tmpKey_1);
              if (_tmpEmailsCollection_1 == null) {
                _tmpEmailsCollection_1 = new ArrayList<ContactEmailWithLabelsRelation>();
              }
              _item = new ContactWithMailsRelation(_tmpContact,_tmpEmailsCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  protected Object deleteContactsSingleBatch(final ContactId[] contactIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEntity WHERE contactId IN (");
        final int _inputSize = contactIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactId _item : contactIds) {
          final String _tmp = __contactConverters.fromContactIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  protected Object deleteAllContactsSingleBatch(final UserId[] userIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEntity WHERE userId IN (");
        final int _inputSize = userIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (UserId _item : userIds) {
          final String _tmp = __commonConverters.fromUserIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity(
      final ArrayMap<String, ArrayList<ContactCardEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<ContactCardEntity>> _tmpInnerMap = new ArrayMap<String, ArrayList<ContactCardEntity>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<ContactCardEntity>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipContactCardEntityAsmeProtonCoreContactDataLocalDbEntityContactCardEntity(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `contactId`,`type`,`data`,`signature`,`cardId` FROM `ContactCardEntity` WHERE `contactId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "contactId");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfContactId = 0;
      final int _cursorIndexOfType = 1;
      final int _cursorIndexOfData = 2;
      final int _cursorIndexOfSignature = 3;
      final int _cursorIndexOfCardId = 4;
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<ContactCardEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final ContactCardEntity _item_1;
          final ContactId _tmpContactId;
          final String _tmp;
          if (_cursor.isNull(_cursorIndexOfContactId)) {
            _tmp = null;
          } else {
            _tmp = _cursor.getString(_cursorIndexOfContactId);
          }
          _tmpContactId = __contactConverters.fromStringToContactId(_tmp);
          final int _tmpType;
          _tmpType = _cursor.getInt(_cursorIndexOfType);
          final String _tmpData;
          if (_cursor.isNull(_cursorIndexOfData)) {
            _tmpData = null;
          } else {
            _tmpData = _cursor.getString(_cursorIndexOfData);
          }
          final String _tmpSignature;
          if (_cursor.isNull(_cursorIndexOfSignature)) {
            _tmpSignature = null;
          } else {
            _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
          }
          _item_1 = new ContactCardEntity(_tmpContactId,_tmpType,_tmpData,_tmpSignature);
          final long _tmpCardId;
          _tmpCardId = _cursor.getLong(_cursorIndexOfCardId);
          _item_1.setCardId(_tmpCardId);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }

  private void __fetchRelationshipContactEmailLabelEntityAsjavaLangString(
      final ArrayMap<String, ArrayList<String>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<String>> _tmpInnerMap = new ArrayMap<String, ArrayList<String>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<String>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `labelId`,`contactEmailId` FROM `ContactEmailLabelEntity` WHERE `contactEmailId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "contactEmailId");
      if (_itemKeyIndex == -1) {
        return;
      }
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<String> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final String _item_1;
          if (_cursor.isNull(0)) {
            _item_1 = null;
          } else {
            _item_1 = _cursor.getString(0);
          }
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }

  private void __fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation(
      final ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>> _tmpInnerMap = new ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<ContactEmailWithLabelsRelation>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipContactEmailEntityAsmeProtonCoreContactDataLocalDbEntityRelationContactEmailWithLabelsRelation(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `userId`,`contactEmailId`,`name`,`email`,`defaults`,`order`,`contactId`,`canonicalEmail`,`isProton` FROM `ContactEmailEntity` WHERE `contactId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, true, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "contactId");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfUserId = 0;
      final int _cursorIndexOfContactEmailId = 1;
      final int _cursorIndexOfName = 2;
      final int _cursorIndexOfEmail = 3;
      final int _cursorIndexOfDefaults = 4;
      final int _cursorIndexOfOrder = 5;
      final int _cursorIndexOfContactId = 6;
      final int _cursorIndexOfCanonicalEmail = 7;
      final int _cursorIndexOfIsProton = 8;
      final ArrayMap<String, ArrayList<String>> _collectionLabelIds = new ArrayMap<String, ArrayList<String>>();
      while (_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
        ArrayList<String> _tmpLabelIdsCollection = _collectionLabelIds.get(_tmpKey);
        if (_tmpLabelIdsCollection == null) {
          _tmpLabelIdsCollection = new ArrayList<String>();
          _collectionLabelIds.put(_tmpKey, _tmpLabelIdsCollection);
        }
      }
      _cursor.moveToPosition(-1);
      __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
      while(_cursor.moveToNext()) {
        final String _tmpKey_1 = _cursor.getString(_itemKeyIndex);
        ArrayList<ContactEmailWithLabelsRelation> _tmpRelation = _map.get(_tmpKey_1);
        if (_tmpRelation != null) {
          final ContactEmailWithLabelsRelation _item_1;
          final ContactEmailEntity _tmpContactEmail;
          if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfContactEmailId) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDefaults) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfContactId) && _cursor.isNull(_cursorIndexOfCanonicalEmail) && _cursor.isNull(_cursorIndexOfIsProton))) {
            final UserId _tmpUserId;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp);
            final ContactEmailId _tmpContactEmailId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfContactEmailId);
            }
            _tmpContactEmailId = __contactConverters.fromStringToContactEmailId(_tmp_1);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final int _tmpDefaults;
            _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final ContactId _tmpContactId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfContactId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfContactId);
            }
            _tmpContactId = __contactConverters.fromStringToContactId(_tmp_2);
            final String _tmpCanonicalEmail;
            if (_cursor.isNull(_cursorIndexOfCanonicalEmail)) {
              _tmpCanonicalEmail = null;
            } else {
              _tmpCanonicalEmail = _cursor.getString(_cursorIndexOfCanonicalEmail);
            }
            final Integer _tmpIsProton;
            if (_cursor.isNull(_cursorIndexOfIsProton)) {
              _tmpIsProton = null;
            } else {
              _tmpIsProton = _cursor.getInt(_cursorIndexOfIsProton);
            }
            _tmpContactEmail = new ContactEmailEntity(_tmpUserId,_tmpContactEmailId,_tmpName,_tmpEmail,_tmpDefaults,_tmpOrder,_tmpContactId,_tmpCanonicalEmail,_tmpIsProton);
          }  else  {
            _tmpContactEmail = null;
          }
          ArrayList<String> _tmpLabelIdsCollection_1 = null;
          final String _tmpKey_2 = _cursor.getString(_cursorIndexOfContactEmailId);
          _tmpLabelIdsCollection_1 = _collectionLabelIds.get(_tmpKey_2);
          if (_tmpLabelIdsCollection_1 == null) {
            _tmpLabelIdsCollection_1 = new ArrayList<String>();
          }
          _item_1 = new ContactEmailWithLabelsRelation(_tmpContactEmail,_tmpLabelIdsCollection_1);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
