package me.proton.core.challenge.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Character;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.challenge.data.entity.ChallengeFrameEntity;
import me.proton.core.data.room.db.CommonConverters;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ChallengeFramesDao_Impl extends ChallengeFramesDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ChallengeFrameEntity> __insertionAdapterOfChallengeFrameEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<ChallengeFrameEntity> __deletionAdapterOfChallengeFrameEntity;

  private final EntityDeletionOrUpdateAdapter<ChallengeFrameEntity> __updateAdapterOfChallengeFrameEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll$challenge_data_release;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByFlow$challenge_data_release;

  private final SharedSQLiteStatement __preparedStmtOfUpdateFrame$challenge_data_release;

  private final ChallengeConverters __challengeConverters = new ChallengeConverters();

  public ChallengeFramesDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfChallengeFrameEntity = new EntityInsertionAdapter<ChallengeFrameEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `ChallengeFrameEntity` (`challengeFrame`,`flow`,`focusTime`,`clicks`,`copy`,`paste`,`keys`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChallengeFrameEntity value) {
        if (value.getChallengeFrame() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getChallengeFrame());
        }
        if (value.getFlow() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getFlow());
        }
        final String _tmp = __commonConverters.fromListOfIntToString(value.getFocusTime());
        if (_tmp == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, _tmp);
        }
        stmt.bindLong(4, value.getClicks());
        final String _tmp_1 = __commonConverters.fromListOfStringToString(value.getCopy());
        if (_tmp_1 == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, _tmp_1);
        }
        final String _tmp_2 = __commonConverters.fromListOfStringToString(value.getPaste());
        if (_tmp_2 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, _tmp_2);
        }
        final String _tmp_3 = __commonConverters.fromListOfStringToString(value.getKeys());
        if (_tmp_3 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, _tmp_3);
        }
      }
    };
    this.__deletionAdapterOfChallengeFrameEntity = new EntityDeletionOrUpdateAdapter<ChallengeFrameEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `ChallengeFrameEntity` WHERE `challengeFrame` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChallengeFrameEntity value) {
        if (value.getChallengeFrame() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getChallengeFrame());
        }
      }
    };
    this.__updateAdapterOfChallengeFrameEntity = new EntityDeletionOrUpdateAdapter<ChallengeFrameEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ChallengeFrameEntity` SET `challengeFrame` = ?,`flow` = ?,`focusTime` = ?,`clicks` = ?,`copy` = ?,`paste` = ?,`keys` = ? WHERE `challengeFrame` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ChallengeFrameEntity value) {
        if (value.getChallengeFrame() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getChallengeFrame());
        }
        if (value.getFlow() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getFlow());
        }
        final String _tmp = __commonConverters.fromListOfIntToString(value.getFocusTime());
        if (_tmp == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, _tmp);
        }
        stmt.bindLong(4, value.getClicks());
        final String _tmp_1 = __commonConverters.fromListOfStringToString(value.getCopy());
        if (_tmp_1 == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, _tmp_1);
        }
        final String _tmp_2 = __commonConverters.fromListOfStringToString(value.getPaste());
        if (_tmp_2 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, _tmp_2);
        }
        final String _tmp_3 = __commonConverters.fromListOfStringToString(value.getKeys());
        if (_tmp_3 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, _tmp_3);
        }
        if (value.getChallengeFrame() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getChallengeFrame());
        }
      }
    };
    this.__preparedStmtOfDeleteAll$challenge_data_release = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM ChallengeFrameEntity";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteByFlow$challenge_data_release = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM ChallengeFrameEntity WHERE flow = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateFrame$challenge_data_release = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE ChallengeFrameEntity SET focusTime = ?, clicks = ?, copy = ?, paste = ?, keys = ? WHERE flow = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final ChallengeFrameEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfChallengeFrameEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final ChallengeFrameEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfChallengeFrameEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final ChallengeFrameEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfChallengeFrameEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final ChallengeFrameEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ChallengeFramesDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAll$challenge_data_release(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll$challenge_data_release.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll$challenge_data_release.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Object deleteByFlow$challenge_data_release(final String flow,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByFlow$challenge_data_release.acquire();
        int _argIndex = 1;
        if (flow == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, flow);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteByFlow$challenge_data_release.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object updateFrame$challenge_data_release(final String flow, final long focusTime,
      final int clicks, final List<String> copy, final List<String> paste,
      final List<Character> keys, final Continuation<? super Unit> arg6) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateFrame$challenge_data_release.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, focusTime);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, clicks);
        _argIndex = 3;
        final String _tmp = __commonConverters.fromListOfStringToString(copy);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 4;
        final String _tmp_1 = __commonConverters.fromListOfStringToString(paste);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 5;
        final String _tmp_2 = __challengeConverters.fromListOfCharToString(keys);
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 6;
        if (flow == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, flow);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateFrame$challenge_data_release.release(_stmt);
        }
      }
    }, arg6);
  }

  @Override
  public Flow<List<ChallengeFrameEntity>> getAll$challenge_data_release() {
    final String _sql = "SELECT * FROM ChallengeFrameEntity";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[]{"ChallengeFrameEntity"}, new Callable<List<ChallengeFrameEntity>>() {
      @Override
      public List<ChallengeFrameEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfChallengeFrame = CursorUtil.getColumnIndexOrThrow(_cursor, "challengeFrame");
          final int _cursorIndexOfFlow = CursorUtil.getColumnIndexOrThrow(_cursor, "flow");
          final int _cursorIndexOfFocusTime = CursorUtil.getColumnIndexOrThrow(_cursor, "focusTime");
          final int _cursorIndexOfClicks = CursorUtil.getColumnIndexOrThrow(_cursor, "clicks");
          final int _cursorIndexOfCopy = CursorUtil.getColumnIndexOrThrow(_cursor, "copy");
          final int _cursorIndexOfPaste = CursorUtil.getColumnIndexOrThrow(_cursor, "paste");
          final int _cursorIndexOfKeys = CursorUtil.getColumnIndexOrThrow(_cursor, "keys");
          final List<ChallengeFrameEntity> _result = new ArrayList<ChallengeFrameEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ChallengeFrameEntity _item;
            final String _tmpChallengeFrame;
            if (_cursor.isNull(_cursorIndexOfChallengeFrame)) {
              _tmpChallengeFrame = null;
            } else {
              _tmpChallengeFrame = _cursor.getString(_cursorIndexOfChallengeFrame);
            }
            final String _tmpFlow;
            if (_cursor.isNull(_cursorIndexOfFlow)) {
              _tmpFlow = null;
            } else {
              _tmpFlow = _cursor.getString(_cursorIndexOfFlow);
            }
            final List<Integer> _tmpFocusTime;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfFocusTime)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfFocusTime);
            }
            _tmpFocusTime = __commonConverters.fromStringToListOfInt(_tmp);
            final int _tmpClicks;
            _tmpClicks = _cursor.getInt(_cursorIndexOfClicks);
            final List<String> _tmpCopy;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCopy)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfCopy);
            }
            _tmpCopy = __commonConverters.fromStringToListOfString(_tmp_1);
            final List<String> _tmpPaste;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfPaste)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfPaste);
            }
            _tmpPaste = __commonConverters.fromStringToListOfString(_tmp_2);
            final List<String> _tmpKeys;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfKeys)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfKeys);
            }
            _tmpKeys = __commonConverters.fromStringToListOfString(_tmp_3);
            _item = new ChallengeFrameEntity(_tmpChallengeFrame,_tmpFlow,_tmpFocusTime,_tmpClicks,_tmpCopy,_tmpPaste,_tmpKeys);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByFlow$challenge_data_release(final String flow,
      final Continuation<? super List<ChallengeFrameEntity>> arg1) {
    final String _sql = "SELECT * FROM ChallengeFrameEntity WHERE flow = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (flow == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, flow);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ChallengeFrameEntity>>() {
      @Override
      public List<ChallengeFrameEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfChallengeFrame = CursorUtil.getColumnIndexOrThrow(_cursor, "challengeFrame");
          final int _cursorIndexOfFlow = CursorUtil.getColumnIndexOrThrow(_cursor, "flow");
          final int _cursorIndexOfFocusTime = CursorUtil.getColumnIndexOrThrow(_cursor, "focusTime");
          final int _cursorIndexOfClicks = CursorUtil.getColumnIndexOrThrow(_cursor, "clicks");
          final int _cursorIndexOfCopy = CursorUtil.getColumnIndexOrThrow(_cursor, "copy");
          final int _cursorIndexOfPaste = CursorUtil.getColumnIndexOrThrow(_cursor, "paste");
          final int _cursorIndexOfKeys = CursorUtil.getColumnIndexOrThrow(_cursor, "keys");
          final List<ChallengeFrameEntity> _result = new ArrayList<ChallengeFrameEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ChallengeFrameEntity _item;
            final String _tmpChallengeFrame;
            if (_cursor.isNull(_cursorIndexOfChallengeFrame)) {
              _tmpChallengeFrame = null;
            } else {
              _tmpChallengeFrame = _cursor.getString(_cursorIndexOfChallengeFrame);
            }
            final String _tmpFlow;
            if (_cursor.isNull(_cursorIndexOfFlow)) {
              _tmpFlow = null;
            } else {
              _tmpFlow = _cursor.getString(_cursorIndexOfFlow);
            }
            final List<Integer> _tmpFocusTime;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfFocusTime)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfFocusTime);
            }
            _tmpFocusTime = __commonConverters.fromStringToListOfInt(_tmp);
            final int _tmpClicks;
            _tmpClicks = _cursor.getInt(_cursorIndexOfClicks);
            final List<String> _tmpCopy;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCopy)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfCopy);
            }
            _tmpCopy = __commonConverters.fromStringToListOfString(_tmp_1);
            final List<String> _tmpPaste;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfPaste)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfPaste);
            }
            _tmpPaste = __commonConverters.fromStringToListOfString(_tmp_2);
            final List<String> _tmpKeys;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfKeys)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfKeys);
            }
            _tmpKeys = __commonConverters.fromStringToListOfString(_tmp_3);
            _item = new ChallengeFrameEntity(_tmpChallengeFrame,_tmpFlow,_tmpFocusTime,_tmpClicks,_tmpCopy,_tmpPaste,_tmpKeys);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getByFlowAndFrame$challenge_data_release(final String flow, final String frame,
      final Continuation<? super ChallengeFrameEntity> arg2) {
    final String _sql = "SELECT * FROM ChallengeFrameEntity WHERE flow = ? AND challengeFrame = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (flow == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, flow);
    }
    _argIndex = 2;
    if (frame == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, frame);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ChallengeFrameEntity>() {
      @Override
      public ChallengeFrameEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfChallengeFrame = CursorUtil.getColumnIndexOrThrow(_cursor, "challengeFrame");
          final int _cursorIndexOfFlow = CursorUtil.getColumnIndexOrThrow(_cursor, "flow");
          final int _cursorIndexOfFocusTime = CursorUtil.getColumnIndexOrThrow(_cursor, "focusTime");
          final int _cursorIndexOfClicks = CursorUtil.getColumnIndexOrThrow(_cursor, "clicks");
          final int _cursorIndexOfCopy = CursorUtil.getColumnIndexOrThrow(_cursor, "copy");
          final int _cursorIndexOfPaste = CursorUtil.getColumnIndexOrThrow(_cursor, "paste");
          final int _cursorIndexOfKeys = CursorUtil.getColumnIndexOrThrow(_cursor, "keys");
          final ChallengeFrameEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpChallengeFrame;
            if (_cursor.isNull(_cursorIndexOfChallengeFrame)) {
              _tmpChallengeFrame = null;
            } else {
              _tmpChallengeFrame = _cursor.getString(_cursorIndexOfChallengeFrame);
            }
            final String _tmpFlow;
            if (_cursor.isNull(_cursorIndexOfFlow)) {
              _tmpFlow = null;
            } else {
              _tmpFlow = _cursor.getString(_cursorIndexOfFlow);
            }
            final List<Integer> _tmpFocusTime;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfFocusTime)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfFocusTime);
            }
            _tmpFocusTime = __commonConverters.fromStringToListOfInt(_tmp);
            final int _tmpClicks;
            _tmpClicks = _cursor.getInt(_cursorIndexOfClicks);
            final List<String> _tmpCopy;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfCopy)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfCopy);
            }
            _tmpCopy = __commonConverters.fromStringToListOfString(_tmp_1);
            final List<String> _tmpPaste;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfPaste)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfPaste);
            }
            _tmpPaste = __commonConverters.fromStringToListOfString(_tmp_2);
            final List<String> _tmpKeys;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfKeys)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfKeys);
            }
            _tmpKeys = __commonConverters.fromStringToListOfString(_tmp_3);
            _result = new ChallengeFrameEntity(_tmpChallengeFrame,_tmpFlow,_tmpFocusTime,_tmpClicks,_tmpCopy,_tmpPaste,_tmpKeys);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg2);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
