package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.entity.SessionEntity;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.Product;
import me.proton.core.domain.entity.UserId;
import me.proton.core.network.domain.session.SessionId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class SessionDao_Impl extends SessionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<SessionEntity> __insertionAdapterOfSessionEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<SessionEntity> __deletionAdapterOfSessionEntity;

  private final EntityDeletionOrUpdateAdapter<SessionEntity> __updateAdapterOfSessionEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfUpdateScopes;

  private final SharedSQLiteStatement __preparedStmtOfUpdateToken;

  public SessionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSessionEntity = new EntityInsertionAdapter<SessionEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `SessionEntity` (`userId`,`sessionId`,`accessToken`,`refreshToken`,`scopes`,`product`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, SessionEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromSessionIdToString(value.getSessionId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getAccessToken() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getAccessToken());
        }
        if (value.getRefreshToken() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getRefreshToken());
        }
        final String _tmp_2 = __commonConverters.fromListOfStringToString(value.getScopes());
        if (_tmp_2 == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, _tmp_2);
        }
        final String _tmp_3 = __commonConverters.fromProductToString(value.getProduct());
        if (_tmp_3 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, _tmp_3);
        }
      }
    };
    this.__deletionAdapterOfSessionEntity = new EntityDeletionOrUpdateAdapter<SessionEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `SessionEntity` WHERE `sessionId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, SessionEntity value) {
        final String _tmp = __commonConverters.fromSessionIdToString(value.getSessionId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfSessionEntity = new EntityDeletionOrUpdateAdapter<SessionEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `SessionEntity` SET `userId` = ?,`sessionId` = ?,`accessToken` = ?,`refreshToken` = ?,`scopes` = ?,`product` = ? WHERE `sessionId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, SessionEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromSessionIdToString(value.getSessionId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getAccessToken() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getAccessToken());
        }
        if (value.getRefreshToken() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getRefreshToken());
        }
        final String _tmp_2 = __commonConverters.fromListOfStringToString(value.getScopes());
        if (_tmp_2 == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, _tmp_2);
        }
        final String _tmp_3 = __commonConverters.fromProductToString(value.getProduct());
        if (_tmp_3 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, _tmp_3);
        }
        final String _tmp_4 = __commonConverters.fromSessionIdToString(value.getSessionId());
        if (_tmp_4 == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, _tmp_4);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM SessionEntity WHERE sessionId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateScopes = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE SessionEntity SET scopes = ? WHERE sessionId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateToken = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE SessionEntity SET accessToken = ?, refreshToken = ? WHERE sessionId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final SessionEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSessionEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final SessionEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfSessionEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final SessionEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfSessionEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final SessionEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> SessionDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final SessionId sessionId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object updateScopes(final SessionId sessionId, final String scopes,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateScopes.acquire();
        int _argIndex = 1;
        if (scopes == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, scopes);
        }
        _argIndex = 2;
        final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateScopes.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Object updateToken(final SessionId sessionId, final String accessToken,
      final String refreshToken, final Continuation<? super Unit> arg3) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateToken.acquire();
        int _argIndex = 1;
        if (accessToken == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, accessToken);
        }
        _argIndex = 2;
        if (refreshToken == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, refreshToken);
        }
        _argIndex = 3;
        final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateToken.release(_stmt);
        }
      }
    }, arg3);
  }

  @Override
  public Flow<List<SessionEntity>> findAll(final Product product) {
    final String _sql = "SELECT * FROM SessionEntity WHERE product = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromProductToString(product);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"SessionEntity"}, new Callable<List<SessionEntity>>() {
      @Override
      public List<SessionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow(_cursor, "accessToken");
          final int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow(_cursor, "refreshToken");
          final int _cursorIndexOfScopes = CursorUtil.getColumnIndexOrThrow(_cursor, "scopes");
          final int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow(_cursor, "product");
          final List<SessionEntity> _result = new ArrayList<SessionEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final SessionEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final SessionId _tmpSessionId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_2);
            final String _tmpAccessToken;
            if (_cursor.isNull(_cursorIndexOfAccessToken)) {
              _tmpAccessToken = null;
            } else {
              _tmpAccessToken = _cursor.getString(_cursorIndexOfAccessToken);
            }
            final String _tmpRefreshToken;
            if (_cursor.isNull(_cursorIndexOfRefreshToken)) {
              _tmpRefreshToken = null;
            } else {
              _tmpRefreshToken = _cursor.getString(_cursorIndexOfRefreshToken);
            }
            final List<String> _tmpScopes;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfScopes)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfScopes);
            }
            _tmpScopes = __commonConverters.fromStringToListOfString(_tmp_3);
            final Product _tmpProduct;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfProduct)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfProduct);
            }
            _tmpProduct = __commonConverters.fromStringToProduct(_tmp_4);
            _item = new SessionEntity(_tmpUserId,_tmpSessionId,_tmpAccessToken,_tmpRefreshToken,_tmpScopes,_tmpProduct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<SessionEntity> findBySessionId(final SessionId sessionId) {
    final String _sql = "SELECT * FROM SessionEntity WHERE sessionId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"SessionEntity"}, new Callable<SessionEntity>() {
      @Override
      public SessionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow(_cursor, "accessToken");
          final int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow(_cursor, "refreshToken");
          final int _cursorIndexOfScopes = CursorUtil.getColumnIndexOrThrow(_cursor, "scopes");
          final int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow(_cursor, "product");
          final SessionEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final SessionId _tmpSessionId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_2);
            final String _tmpAccessToken;
            if (_cursor.isNull(_cursorIndexOfAccessToken)) {
              _tmpAccessToken = null;
            } else {
              _tmpAccessToken = _cursor.getString(_cursorIndexOfAccessToken);
            }
            final String _tmpRefreshToken;
            if (_cursor.isNull(_cursorIndexOfRefreshToken)) {
              _tmpRefreshToken = null;
            } else {
              _tmpRefreshToken = _cursor.getString(_cursorIndexOfRefreshToken);
            }
            final List<String> _tmpScopes;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfScopes)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfScopes);
            }
            _tmpScopes = __commonConverters.fromStringToListOfString(_tmp_3);
            final Product _tmpProduct;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfProduct)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfProduct);
            }
            _tmpProduct = __commonConverters.fromStringToProduct(_tmp_4);
            _result = new SessionEntity(_tmpUserId,_tmpSessionId,_tmpAccessToken,_tmpRefreshToken,_tmpScopes,_tmpProduct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object get(final SessionId sessionId, final Continuation<? super SessionEntity> arg1) {
    final String _sql = "SELECT * FROM SessionEntity WHERE sessionId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromSessionIdToString(sessionId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SessionEntity>() {
      @Override
      public SessionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "sessionId");
          final int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow(_cursor, "accessToken");
          final int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow(_cursor, "refreshToken");
          final int _cursorIndexOfScopes = CursorUtil.getColumnIndexOrThrow(_cursor, "scopes");
          final int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow(_cursor, "product");
          final SessionEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final SessionId _tmpSessionId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfSessionId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfSessionId);
            }
            _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_2);
            final String _tmpAccessToken;
            if (_cursor.isNull(_cursorIndexOfAccessToken)) {
              _tmpAccessToken = null;
            } else {
              _tmpAccessToken = _cursor.getString(_cursorIndexOfAccessToken);
            }
            final String _tmpRefreshToken;
            if (_cursor.isNull(_cursorIndexOfRefreshToken)) {
              _tmpRefreshToken = null;
            } else {
              _tmpRefreshToken = _cursor.getString(_cursorIndexOfRefreshToken);
            }
            final List<String> _tmpScopes;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfScopes)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfScopes);
            }
            _tmpScopes = __commonConverters.fromStringToListOfString(_tmp_3);
            final Product _tmpProduct;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfProduct)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfProduct);
            }
            _tmpProduct = __commonConverters.fromStringToProduct(_tmp_4);
            _result = new SessionEntity(_tmpUserId,_tmpSessionId,_tmpAccessToken,_tmpRefreshToken,_tmpScopes,_tmpProduct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getSessionId(final UserId userId, final Continuation<? super SessionId> arg1) {
    final String _sql = "SELECT sessionId FROM SessionEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SessionId>() {
      @Override
      public SessionId call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final SessionId _result;
          if(_cursor.moveToFirst()) {
            final String _tmp_1;
            if (_cursor.isNull(0)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(0);
            }
            _result = __commonConverters.fromStringToSessionId(_tmp_1);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getUnauthenticatedSessionId(final Continuation<? super SessionId> arg0) {
    final String _sql = "SELECT sessionId FROM SessionEntity WHERE userId IS NULL";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SessionId>() {
      @Override
      public SessionId call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final SessionId _result;
          if(_cursor.moveToFirst()) {
            final String _tmp;
            if (_cursor.isNull(0)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(0);
            }
            _result = __commonConverters.fromStringToSessionId(_tmp);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg0);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
