package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.entity.AccountMetadataEntity;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.Product;
import me.proton.core.domain.entity.UserId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AccountMetadataDao_Impl extends AccountMetadataDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AccountMetadataEntity> __insertionAdapterOfAccountMetadataEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<AccountMetadataEntity> __deletionAdapterOfAccountMetadataEntity;

  private final EntityDeletionOrUpdateAdapter<AccountMetadataEntity> __updateAdapterOfAccountMetadataEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfUpdateMigrations;

  public AccountMetadataDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAccountMetadataEntity = new EntityInsertionAdapter<AccountMetadataEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `AccountMetadataEntity` (`userId`,`product`,`primaryAtUtc`,`migrations`) VALUES (?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AccountMetadataEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromProductToString(value.getProduct());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        stmt.bindLong(3, value.getPrimaryAtUtc());
        final String _tmp_2 = __commonConverters.fromListOfStringToString(value.getMigrations());
        if (_tmp_2 == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, _tmp_2);
        }
      }
    };
    this.__deletionAdapterOfAccountMetadataEntity = new EntityDeletionOrUpdateAdapter<AccountMetadataEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `AccountMetadataEntity` WHERE `userId` = ? AND `product` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AccountMetadataEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromProductToString(value.getProduct());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
      }
    };
    this.__updateAdapterOfAccountMetadataEntity = new EntityDeletionOrUpdateAdapter<AccountMetadataEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `AccountMetadataEntity` SET `userId` = ?,`product` = ?,`primaryAtUtc` = ?,`migrations` = ? WHERE `userId` = ? AND `product` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AccountMetadataEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __commonConverters.fromProductToString(value.getProduct());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        stmt.bindLong(3, value.getPrimaryAtUtc());
        final String _tmp_2 = __commonConverters.fromListOfStringToString(value.getMigrations());
        if (_tmp_2 == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, _tmp_2);
        }
        final String _tmp_3 = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp_3 == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, _tmp_3);
        }
        final String _tmp_4 = __commonConverters.fromProductToString(value.getProduct());
        if (_tmp_4 == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, _tmp_4);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM AccountMetadataEntity WHERE product = ? AND userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateMigrations = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE AccountMetadataEntity SET migrations = ? WHERE product = ? AND userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final AccountMetadataEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAccountMetadataEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final AccountMetadataEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfAccountMetadataEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final AccountMetadataEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfAccountMetadataEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final AccountMetadataEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AccountMetadataDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final Product product, final UserId userId,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromProductToString(product);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Object updateMigrations(final Product product, final UserId userId,
      final List<String> migrations, final Continuation<? super Unit> arg3) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateMigrations.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromListOfStringToString(migrations);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        final String _tmp_1 = __commonConverters.fromProductToString(product);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        _argIndex = 3;
        final String _tmp_2 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_2);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateMigrations.release(_stmt);
        }
      }
    }, arg3);
  }

  @Override
  public Flow<AccountMetadataEntity> observeLatestPrimary(final Product product) {
    final String _sql = "SELECT * FROM AccountMetadataEntity WHERE product = ? AND primaryAtUtc = (SELECT MAX(primaryAtUtc) FROM AccountMetadataEntity) LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromProductToString(product);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"AccountMetadataEntity"}, new Callable<AccountMetadataEntity>() {
      @Override
      public AccountMetadataEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow(_cursor, "product");
          final int _cursorIndexOfPrimaryAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryAtUtc");
          final int _cursorIndexOfMigrations = CursorUtil.getColumnIndexOrThrow(_cursor, "migrations");
          final AccountMetadataEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final Product _tmpProduct;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfProduct)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfProduct);
            }
            _tmpProduct = __commonConverters.fromStringToProduct(_tmp_2);
            final long _tmpPrimaryAtUtc;
            _tmpPrimaryAtUtc = _cursor.getLong(_cursorIndexOfPrimaryAtUtc);
            final List<String> _tmpMigrations;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMigrations)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfMigrations);
            }
            _tmpMigrations = __commonConverters.fromStringToListOfString(_tmp_3);
            _result = new AccountMetadataEntity(_tmpUserId,_tmpProduct,_tmpPrimaryAtUtc,_tmpMigrations);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAllDescending(final Product product,
      final Continuation<? super List<AccountMetadataEntity>> arg1) {
    final String _sql = "SELECT * FROM AccountMetadataEntity WHERE product = ? ORDER BY primaryAtUtc DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromProductToString(product);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AccountMetadataEntity>>() {
      @Override
      public List<AccountMetadataEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow(_cursor, "product");
          final int _cursorIndexOfPrimaryAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryAtUtc");
          final int _cursorIndexOfMigrations = CursorUtil.getColumnIndexOrThrow(_cursor, "migrations");
          final List<AccountMetadataEntity> _result = new ArrayList<AccountMetadataEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final AccountMetadataEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final Product _tmpProduct;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfProduct)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfProduct);
            }
            _tmpProduct = __commonConverters.fromStringToProduct(_tmp_2);
            final long _tmpPrimaryAtUtc;
            _tmpPrimaryAtUtc = _cursor.getLong(_cursorIndexOfPrimaryAtUtc);
            final List<String> _tmpMigrations;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfMigrations)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfMigrations);
            }
            _tmpMigrations = __commonConverters.fromStringToListOfString(_tmp_3);
            _item = new AccountMetadataEntity(_tmpUserId,_tmpProduct,_tmpPrimaryAtUtc,_tmpMigrations);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getByUserId(final Product product, final UserId userId,
      final Continuation<? super AccountMetadataEntity> arg2) {
    final String _sql = "SELECT * FROM AccountMetadataEntity WHERE product = ? AND userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromProductToString(product);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
    if (_tmp_1 == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp_1);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<AccountMetadataEntity>() {
      @Override
      public AccountMetadataEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow(_cursor, "product");
          final int _cursorIndexOfPrimaryAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryAtUtc");
          final int _cursorIndexOfMigrations = CursorUtil.getColumnIndexOrThrow(_cursor, "migrations");
          final AccountMetadataEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_2);
            final Product _tmpProduct;
            final String _tmp_3;
            if (_cursor.isNull(_cursorIndexOfProduct)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getString(_cursorIndexOfProduct);
            }
            _tmpProduct = __commonConverters.fromStringToProduct(_tmp_3);
            final long _tmpPrimaryAtUtc;
            _tmpPrimaryAtUtc = _cursor.getLong(_cursorIndexOfPrimaryAtUtc);
            final List<String> _tmpMigrations;
            final String _tmp_4;
            if (_cursor.isNull(_cursorIndexOfMigrations)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getString(_cursorIndexOfMigrations);
            }
            _tmpMigrations = __commonConverters.fromStringToListOfString(_tmp_4);
            _result = new AccountMetadataEntity(_tmpUserId,_tmpProduct,_tmpPrimaryAtUtc,_tmpMigrations);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg2);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
