/*
 * Decompiled with CFR 0.152.
 */
package me.nullaqua.api.serialize;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.nullaqua.api.collection.Vector;
import me.nullaqua.api.reflect.FieldAccessor;
import me.nullaqua.api.serialize.SerializeObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0014J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J*\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lme/nullaqua/api/serialize/SimpleObject;", "Lme/nullaqua/api/serialize/SerializeObject;", "o", "", "(Ljava/lang/Object;)V", "serializeClass", "Ljava/lang/Class;", "getSerializeClass", "()Ljava/lang/Class;", "blankInstance", "deserialize", "", "string", "", "deserializeTo", "to", "toString", "map", "", "", "res", "Lme/nullaqua/api/collection/Vector;", "Companion", "BluestarAPI-kotlin"})
@SourceDebugExtension(value={"SMAP\nSerialize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Serialize.kt\nme/nullaqua/api/serialize/SimpleObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Reflection.kt\nme/nullaqua/kotlin/reflect/KotlinReflection\n*L\n1#1,547:1\n1#2:548\n24#3,5:549\n24#3,5:554\n24#3,5:559\n24#3,5:564\n*S KotlinDebug\n*F\n+ 1 Serialize.kt\nme/nullaqua/api/serialize/SimpleObject\n*L\n291#1:549,5\n292#1:554,5\n319#1:559,5\n320#1:564,5\n*E\n"})
public final class SimpleObject
extends SerializeObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Object o;
    @NotNull
    private final Class<?> serializeClass;
    @JvmField
    @NotNull
    public static final Map<Class<? extends Object>, Class<? extends Object>> simpleClasses;

    public SimpleObject(@Nullable Object o) {
        super(null);
        Class<?> serializeClass;
        this.o = o;
        Class<?> clazz = this.o;
        if (clazz == null || (clazz = clazz.getClass()) == null) {
            Class<Void> clazz2 = Void.TYPE;
            clazz = clazz2;
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"TYPE");
        }
        if (!(simpleClasses.containsKey(serializeClass = clazz) || simpleClasses.containsValue(serializeClass))) {
            boolean bl = false;
            String string = "Not a simple class";
            throw new IllegalArgumentException(string.toString());
        }
        if (simpleClasses.containsValue(serializeClass)) {
            this.serializeClass = serializeClass;
        } else {
            Class<? extends Object> clazz3 = simpleClasses.get(serializeClass);
            Intrinsics.checkNotNull(clazz3);
            this.serializeClass = clazz3;
        }
    }

    @Override
    @NotNull
    public Class<?> getSerializeClass() {
        return this.serializeClass;
    }

    @Override
    public void deserializeTo(@Nullable Object to) {
    }

    @Override
    @Nullable
    protected Object blankInstance() {
        return this.o;
    }

    @Override
    public void toString(@NotNull Map<SerializeObject, Integer> map, @NotNull Vector<String> res) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(res, (String)"res");
    }

    @Override
    @NotNull
    public String toString() {
        if (Intrinsics.areEqual(this.getSerializeClass(), Void.TYPE)) {
            return "null";
        }
        if (Intrinsics.areEqual(this.getSerializeClass(), String.class)) {
            StringBuilder sb = new StringBuilder();
            sb.append("String@");
            Object object = this.o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.String");
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            for (byte c : byArray) {
                sb.append(Integer.toHexString(c >> 4 & 0xF));
                sb.append(Integer.toHexString(c & 0xF));
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        if (Intrinsics.areEqual(this.getSerializeClass(), Boolean.TYPE)) {
            StringBuilder stringBuilder = new StringBuilder().append("boolean@");
            Object object = this.o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            return stringBuilder.append((Boolean)object).toString();
        }
        if (Intrinsics.areEqual(this.getSerializeClass(), Double.TYPE)) {
            StringBuilder stringBuilder = new StringBuilder().append("double@");
            Object object = this.o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            long l = Double.doubleToRawLongBits((Double)object);
            int n = 16;
            String string = Long.toString(l, CharsKt.checkRadix((int)n));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return stringBuilder.append(string).toString();
        }
        if (Intrinsics.areEqual(this.getSerializeClass(), Float.TYPE)) {
            StringBuilder stringBuilder = new StringBuilder().append("float@");
            Object object = this.o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            int n = Float.floatToRawIntBits(((Float)object).floatValue());
            int n2 = 16;
            String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return stringBuilder.append(string).toString();
        }
        if (Intrinsics.areEqual(this.getSerializeClass(), Character.TYPE)) {
            StringBuilder stringBuilder = new StringBuilder().append("char@");
            Object object = this.o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Char");
            char c = ((Character)object).charValue();
            int n = 16;
            String string = Integer.toString(c, CharsKt.checkRadix((int)n));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return stringBuilder.append(string).toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append(this.getSerializeClass().getName()).append('@');
        Object object = this.o;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        long l = ((Number)object).longValue();
        int n = 16;
        String string = Long.toString(l, CharsKt.checkRadix((int)n));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).toString();
    }

    public final void deserialize(@NotNull String string) {
        block42: {
            FieldAccessor field$iv;
            SimpleObject $this$setField$iv;
            Object object;
            Object clazz$iv;
            Object t$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (Intrinsics.areEqual((Object)string, (Object)"null")) {
                String fieldName$iv;
                FieldAccessor field$iv2;
                SimpleObject $this$setField$iv2;
                SimpleObject simpleObject = this;
                String string2 = "o";
                Class<Void> value$iv = null;
                boolean $i$f$setField = false;
                void v0 = $this$setField$iv2;
                if (v0 != null) {
                    t$iv = v0;
                    clazz$iv = t$iv.getClass();
                    FieldAccessor fieldAccessor = field$iv2 = FieldAccessor.getDeclaredField(clazz$iv, (String)fieldName$iv);
                    if (fieldAccessor != null) {
                        fieldAccessor.set(t$iv, value$iv);
                    }
                }
                $this$setField$iv2 = this;
                fieldName$iv = "serializeClass";
                value$iv = Void.TYPE;
                $i$f$setField = false;
                SimpleObject simpleObject2 = $this$setField$iv2;
                if (simpleObject2 != null) {
                    t$iv = simpleObject2;
                    clazz$iv = t$iv.getClass();
                    FieldAccessor fieldAccessor = field$iv2 = FieldAccessor.getDeclaredField(clazz$iv, (String)fieldName$iv);
                    if (fieldAccessor != null) {
                        fieldAccessor.set(t$iv, value$iv);
                    }
                }
            }
            int i = StringsKt.indexOf$default((CharSequence)string, (char)'@', (int)0, (boolean)false, (int)6, null);
            String string3 = string.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String s = string3;
            String string4 = string.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String x = string4;
            switch (s) {
                case "String": {
                    StringBuilder sb = new StringBuilder();
                    int n = x.length() + -1;
                    int t = 0;
                    int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
                    if (t <= n2) {
                        while (true) {
                            String string5 = x.substring(t, t + 2);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                            sb.append((char)Integer.parseInt(string5, 16));
                            if (t == n2) break;
                            t += 2;
                        }
                    }
                    clazz$iv = sb.toString();
                    Intrinsics.checkNotNull((Object)clazz$iv);
                    object = clazz$iv;
                    break;
                }
                case "boolean": {
                    object = Boolean.parseBoolean(x);
                    break;
                }
                case "double": {
                    object = Double.longBitsToDouble(Long.parseLong(x, 16));
                    break;
                }
                case "float": {
                    object = Float.valueOf(Float.intBitsToFloat(Integer.parseInt(x, 16)));
                    break;
                }
                case "char": {
                    object = Character.valueOf((char)Integer.parseInt(x, CharsKt.checkRadix((int)16)));
                    break;
                }
                case "int": {
                    object = (int)Long.parseLong(x, 16);
                    break;
                }
                case "long": {
                    object = Long.parseLong(x, 16);
                    break;
                }
                case "short": {
                    object = (short)Long.parseLong(x, 16);
                    break;
                }
                case "byte": {
                    object = (byte)Long.parseLong(x, 16);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type");
                }
            }
            Comparable<Boolean> o = object;
            t$iv = this;
            String fieldName$iv = "o";
            boolean $i$f$setField = false;
            void v8 = $this$setField$iv;
            if (v8 != null) {
                FieldAccessor field$iv3;
                void t$iv2 = v8;
                Class<?> clazz$iv2 = t$iv2.getClass();
                FieldAccessor fieldAccessor = field$iv3 = FieldAccessor.getDeclaredField(clazz$iv2, (String)fieldName$iv);
                if (fieldAccessor != null) {
                    fieldAccessor.set((Object)t$iv2, o);
                }
            }
            $this$setField$iv = this;
            fieldName$iv = "serializeClass";
            Class value$iv = Intrinsics.areEqual((Object)s, (Object)"String") ? String.class : JvmClassMappingKt.getJavaPrimitiveType((KClass)Reflection.getOrCreateKotlinClass(o.getClass()));
            boolean $i$f$setField2 = false;
            SimpleObject simpleObject = $this$setField$iv;
            if (simpleObject == null) break block42;
            SimpleObject t$iv3 = simpleObject;
            Class<?> clazz$iv3 = t$iv3.getClass();
            FieldAccessor fieldAccessor = field$iv = FieldAccessor.getDeclaredField(clazz$iv3, (String)fieldName$iv);
            if (fieldAccessor != null) {
                fieldAccessor.set((Object)t$iv3, (Object)value$iv);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(String.class, String.class), TuplesKt.to(Integer.class, Integer.TYPE), TuplesKt.to(Long.class, Long.TYPE), TuplesKt.to(Short.class, Short.TYPE), TuplesKt.to(Byte.class, Byte.TYPE), TuplesKt.to(Character.class, Character.TYPE), TuplesKt.to(Boolean.class, Boolean.TYPE), TuplesKt.to(Float.class, Float.TYPE), TuplesKt.to(Double.class, Double.TYPE), TuplesKt.to(Void.class, Void.TYPE)};
        simpleClasses = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R.\u0010\u0003\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/nullaqua/api/serialize/SimpleObject$Companion;", "", "()V", "simpleClasses", "", "Ljava/lang/Class;", "BluestarAPI-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

