/*
 * Decompiled with CFR 0.152.
 */
package me.nathanfallet.usecases.models.annotations.validators;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import me.nathanfallet.usecases.models.annotations.validators.PropertyValidatorException;
import me.nathanfallet.usecases.models.annotations.validators.StringPropertyValidator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007\u00a8\u0006\t"}, d2={"Lme/nathanfallet/usecases/models/annotations/validators/PropertyValidator;", "", "()V", "validate", "", "key", "", "value", "validator", "usecases"})
public final class PropertyValidator {
    @NotNull
    public static final PropertyValidator INSTANCE = new PropertyValidator();

    private PropertyValidator() {
    }

    @JvmStatic
    public static final void validate(@NotNull String key, @NotNull Object value, @NotNull Object validator) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        if (validator instanceof StringPropertyValidator) {
            if (!(value instanceof String)) {
                throw new PropertyValidatorException(key, value, validator, "type");
            }
            CharSequence charSequence = (CharSequence)value;
            if (!new Regex(((StringPropertyValidator)validator).regex()).matches(charSequence)) {
                throw new PropertyValidatorException(key, value, validator, "regex");
            }
            if (((String)value).length() < ((StringPropertyValidator)validator).minLength()) {
                throw new PropertyValidatorException(key, value, validator, "minLength");
            }
            if (((String)value).length() > ((StringPropertyValidator)validator).maxLength()) {
                throw new PropertyValidatorException(key, value, validator, "maxLength");
            }
        }
    }
}

