package me.nathanfallet.ringify.repositories.watchers

import io.ktor.util.reflect.*
import me.nathanfallet.ktorx.repositories.api.APIChildModelRemoteRepository
import me.nathanfallet.ktorx.repositories.api.IAPIChildModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.teams.Team
import me.nathanfallet.ringify.models.users.User
import me.nathanfallet.ringify.models.watchers.CreateWatcherPayload
import me.nathanfallet.ringify.models.watchers.Watcher
import me.nathanfallet.usecases.models.id.RecursiveId

class WatchersRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<User, String, *, *, *>,
) : APIChildModelRemoteRepository<Watcher, String, CreateWatcherPayload, Unit, String>(
    typeInfo<Watcher>(),
    typeInfo<CreateWatcherPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<Watcher>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), IWatchersRemoteRepository {

    override suspend fun create(payload: CreateWatcherPayload, userId: String): Watcher? =
        create(payload, RecursiveId<Team, String, Unit>(userId), null)

    override suspend fun delete(sourceId: String, userId: String): Boolean =
        delete(sourceId, RecursiveId<Team, String, Unit>(userId), null)

}
