package me.nathanfallet.ringify.repositories.teams

import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import me.nathanfallet.ktorx.repositories.api.APIModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.application.SearchOptions
import me.nathanfallet.ringify.models.duels.Duel
import me.nathanfallet.ringify.models.entries.Entry
import me.nathanfallet.ringify.models.teams.CreateTeamPayload
import me.nathanfallet.ringify.models.teams.Team
import me.nathanfallet.ringify.models.teams.UpdateTeamPayload
import me.nathanfallet.usecases.models.UnitModel
import me.nathanfallet.usecases.models.id.RecursiveId
import me.nathanfallet.usecases.pagination.IPaginationOptions
import me.nathanfallet.usecases.pagination.Pagination

class TeamsRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<Team, String, CreateTeamPayload, UpdateTeamPayload>(
    typeInfo<Team>(),
    typeInfo<CreateTeamPayload>(),
    typeInfo<UpdateTeamPayload>(),
    typeInfo<List<Team>>(),
    client,
    prefix = "/api/v1"
), ITeamsRemoteRepository {

    override fun encodePaginationOptions(options: IPaginationOptions, builder: HttpRequestBuilder) = when (options) {
        is SearchOptions -> builder.parameter("search", options.search)
        else -> super.encodePaginationOptions(options, builder)
    }

    override suspend fun list(pagination: Pagination): List<Team> = list(pagination, null)

    override suspend fun get(id: String): Team? = get(id, null)

    override suspend fun create(payload: CreateTeamPayload): Team? = create(payload, null)

    override suspend fun update(id: String, payload: UpdateTeamPayload): Team? = update(id, payload, null)

    override suspend fun listDuels(id: String): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels")
        .body()

    override suspend fun listEntries(id: String, date: String): List<Entry> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/entries/$date")
        .body()

}
