package me.nathanfallet.ringify.repositories.notifications

import io.ktor.util.reflect.*
import me.nathanfallet.ktorx.repositories.api.APIChildModelRemoteRepository
import me.nathanfallet.ktorx.repositories.api.IAPIChildModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.notifications.CreateNotificationTokenPayload
import me.nathanfallet.ringify.models.notifications.NotificationToken
import me.nathanfallet.ringify.models.users.User
import me.nathanfallet.usecases.models.id.RecursiveId

class NotificationTokensRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<User, String, *, *, *>,
) : APIChildModelRemoteRepository<NotificationToken, String, CreateNotificationTokenPayload, Unit, String>(
    typeInfo<NotificationToken>(),
    typeInfo<CreateNotificationTokenPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<NotificationToken>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), INotificationTokensRemoteRepository {

    override suspend fun create(payload: CreateNotificationTokenPayload, userId: String): NotificationToken? =
        create(payload, RecursiveId<User, String, Unit>(userId), null)

}
