package me.nathanfallet.ringify.repositories.duels

import me.nathanfallet.ringify.models.duels.CreateDuelPayload
import me.nathanfallet.ringify.models.duels.Duel
import me.nathanfallet.ringify.models.entries.Entry

interface IDuelsRemoteRepository {

    suspend fun get(id: String): Duel?
    suspend fun create(payload: CreateDuelPayload): Duel?
    suspend fun accept(id: String): Duel?
    suspend fun decline(id: String): Boolean
    suspend fun listEntries(id: String): List<Entry>

}
