package me.nathanfallet.ringify.models.watchers

import kotlinx.serialization.Serializable
import me.nathanfallet.usecases.models.IChildModel
import me.nathanfallet.usecases.models.annotations.Schema

@Serializable
data class Watcher(
    @Schema("The user watching the target")
    val sourceId: String,
    @Schema("The target being watched")
    val targetId: String,
) : IChildModel<String, CreateWatcherPayload, Unit, String> {

    override val id: String
        get() = sourceId

    override val parentId: String
        get() = targetId

}
