package me.nathanfallet.ringify.models.teams

import kotlinx.serialization.Serializable
import me.nathanfallet.ringify.models.users.User
import me.nathanfallet.usecases.models.IChildModel

@Serializable
data class UserInTeam(
    val userId: String,
    val teamId: String,
    val isAdmin: Boolean,
    val user: User? = null,
    val team: Team? = null,
) : IChildModel<String, CreateUserInTeamPayload, Unit, String> {

    override val id: String
        get() = userId

    override val parentId: String
        get() = teamId

}
