package me.nathanfallet.ringify.models.teams

import kotlinx.serialization.Serializable
import me.nathanfallet.usecases.models.IModel
import me.nathanfallet.usecases.models.annotations.Schema

@Serializable
data class Team(
    @Schema("Id of the Team", "123abc")
    override val id: String,
    @Schema("Name of the Team", "Team")
    val name: String,
    @Schema("If the Team is public or not", "true")
    val isPublic: Boolean,
    @Schema("Number of users in the Team", "5")
    val usersCount: Long,
    @Schema("Is current user a member of the team?", "true")
    val isMember: Boolean?,
) : IModel<String, CreateTeamPayload, UpdateTeamPayload>
