package me.nathanfallet.ringify.models.duels

import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable
import me.nathanfallet.ringify.models.users.User
import me.nathanfallet.usecases.models.IModel
import me.nathanfallet.usecases.models.annotations.Schema

@Serializable
data class Duel(
    @Schema("Id of the Duel", "123abc")
    override val id: String,
    @Schema("Id of the user who created the duel", "abc123")
    val creatorId: String,
    @Schema("Id of the user who accepted the duel", "abc123")
    val opponentId: String,
    @Schema("Date the duel starts at", "2021-01-01")
    val startsAt: LocalDate,
    @Schema("Date the duel ends at", "2021-01-01")
    val endsAt: LocalDate,
    @Schema("If the duel was accepted by the opponent", "true")
    val isAccepted: Boolean,
    @Schema("Id of the user who won the duel", "abc123")
    val winnerId: String?,
    @Schema("User object of the creator of the duel")
    val creator: User? = null,
    @Schema("User object of the opponent of the duel")
    val opponent: User? = null,
) : IModel<String, CreateDuelPayload, UpdateDuelPayload>
