package me.nathanfallet.ringify.client

import me.nathanfallet.ktorx.models.api.AbstractAPIClient
import me.nathanfallet.ktorx.usecases.api.IGetTokenUseCase
import me.nathanfallet.ktorx.usecases.api.ILogoutUseCase
import me.nathanfallet.ktorx.usecases.api.IRenewTokenUseCase
import me.nathanfallet.ringify.models.application.RingifyEnvironment
import me.nathanfallet.ringify.models.application.RingifyJson
import me.nathanfallet.ringify.repositories.auth.AuthAPIRemoteRepository
import me.nathanfallet.ringify.repositories.duels.DuelsRemoteRepository
import me.nathanfallet.ringify.repositories.entries.EntriesRemoteRepository
import me.nathanfallet.ringify.repositories.notifications.NotificationTokensRemoteRepository
import me.nathanfallet.ringify.repositories.teams.TeamsRemoteRepository
import me.nathanfallet.ringify.repositories.teams.UsersInTeamsRemoteRepository
import me.nathanfallet.ringify.repositories.users.UsersRemoteRepository
import me.nathanfallet.ringify.repositories.watchers.WatchersRemoteRepository

class RingifyClient(
    getTokenUseCase: IGetTokenUseCase,
    renewTokenUseCase: IRenewTokenUseCase,
    logoutUseCase: ILogoutUseCase,
    environment: RingifyEnvironment = RingifyEnvironment.PRODUCTION,
) : AbstractAPIClient(
    environment.baseUrl,
    getTokenUseCase,
    renewTokenUseCase,
    logoutUseCase,
    RingifyJson.json
), IRingifyClient {

    override val auth = AuthAPIRemoteRepository(this)
    override val users = UsersRemoteRepository(this)
    override val duels = DuelsRemoteRepository(this)
    override val entries = EntriesRemoteRepository(this, users)
    override val notificationTokens = NotificationTokensRemoteRepository(this, users)
    override val teams = TeamsRemoteRepository(this)
    override val usersInTeams = UsersInTeamsRemoteRepository(this, teams)
    override val watchers = WatchersRemoteRepository(this, users)

}
