package me.nathanfallet.ringify.usecases.entries

import kotlinx.datetime.LocalDate
import me.nathanfallet.ringify.models.entries.Entry
import me.nathanfallet.ringify.models.entries.EntryScores

class ComputeScoresForEntriesUseCase : IComputeScoresForEntriesUseCase {

    override suspend fun invoke(input1: List<Entry>, input2: List<Entry>, input3: LocalDate): EntryScores {
        val creatorEntry = input1.firstOrNull { it.date == input3 }
        val opponentEntry = input2.firstOrNull { it.date == input3 }

        return computeScore(creatorEntry?.move ?: 0, opponentEntry?.move ?: 0) +
                computeScore(creatorEntry?.exercise ?: 0, opponentEntry?.exercise ?: 0) +
                computeScore(creatorEntry?.stand ?: 0, opponentEntry?.stand ?: 0)
    }

    private fun computeScore(creator: Int, opponent: Int): EntryScores = when {
        creator > opponent -> EntryScores(1, 0)
        creator < opponent -> EntryScores(0, 1)
        else -> EntryScores(1, 1)
    }

}
