package me.nathanfallet.ringify.repositories.users

import io.ktor.client.call.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import me.nathanfallet.ktorx.repositories.api.APIModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.duels.Duel
import me.nathanfallet.ringify.models.teams.UserInTeam
import me.nathanfallet.ringify.models.users.CreateUserPayload
import me.nathanfallet.ringify.models.users.UpdateUserPayload
import me.nathanfallet.ringify.models.users.User
import me.nathanfallet.usecases.models.UnitModel
import me.nathanfallet.usecases.models.id.RecursiveId

class UsersRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<User, String, CreateUserPayload, UpdateUserPayload>(
    typeInfo<User>(),
    typeInfo<CreateUserPayload>(),
    typeInfo<UpdateUserPayload>(),
    typeInfo<List<User>>(),
    client,
    prefix = "/api/v1"
), IUsersRemoteRepository {

    override suspend fun get(id: String): User? = get(id, null)

    override suspend fun update(id: String, payload: UpdateUserPayload): User? = update(id, payload, null)

    override suspend fun delete(id: String) = delete(id, null)

    override suspend fun listTeams(id: String): List<UserInTeam> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/teams")
        .body()

    override suspend fun listDuels(id: String): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels")
        .body()

    override suspend fun listEndedDuels(id: String): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels/ended")
        .body()

    override suspend fun listPendingDuels(id: String): List<Duel> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/duels/pending")
        .body()

}
