package me.nathanfallet.ringify.repositories.entries

import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import kotlinx.datetime.LocalDate
import me.nathanfallet.ktorx.repositories.api.APIChildModelRemoteRepository
import me.nathanfallet.ktorx.repositories.api.IAPIChildModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.entries.BatchEntryPayload
import me.nathanfallet.ringify.models.entries.Entry
import me.nathanfallet.ringify.models.entries.EntryPayload
import me.nathanfallet.ringify.models.users.User
import me.nathanfallet.usecases.models.id.RecursiveId

class EntriesRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<User, String, *, *, *>,
) : APIChildModelRemoteRepository<Entry, LocalDate, EntryPayload, EntryPayload, String>(
    typeInfo<Entry>(),
    typeInfo<EntryPayload>(),
    typeInfo<EntryPayload>(),
    typeInfo<List<Entry>>(),
    client,
    parentRepository,
    prefix = "/api/v1",
    route = "entries"
), IEntriesRemoteRepository {

    override suspend fun create(payload: EntryPayload, userId: String): Entry? =
        create(payload, RecursiveId<User, String, Unit>(userId), null)

    override suspend fun createBatch(payload: BatchEntryPayload, userId: String): List<Entry> =
        client.request(HttpMethod.Post, constructFullRoute(RecursiveId<User, String, Unit>(userId))) {
            contentType(ContentType.Application.Json)
            setBody(payload)
        }.body()


}
