package me.nathanfallet.ringify.models.users

import kotlinx.serialization.Serializable
import me.nathanfallet.usecases.models.IModel
import me.nathanfallet.usecases.models.annotations.Schema
import me.nathanfallet.usecases.users.IUser

@Serializable
data class User(
    @Schema("Id of the User", "123abc")
    override val id: String,
    @Schema("Name of the User", "Nathan")
    val name: String,
    @Schema("Avatar of the User", "https://...")
    val avatar: String,
    @Schema("Number of ended duels")
    val endedDuelsCount: Long? = null,
    @Schema("Number of won duels")
    val wonDuelsCount: Long? = null,
    @Schema("If the current user is watching this user")
    val isWatchedByMe: Boolean? = null,
) : IModel<String, CreateUserPayload, UpdateUserPayload>, IUser
