package me.nathanfallet.ringify.models.entries

import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable
import me.nathanfallet.usecases.models.IChildModel
import me.nathanfallet.usecases.models.annotations.Schema

@Serializable
data class Entry(
    @Schema("Id of the user owning the entry", "123abc")
    val userId: String,
    @Schema("Date of the entry", "2021-01-01")
    val date: LocalDate,
    @Schema("Value of the move ring", "0")
    val move: Int,
    @Schema("Value of the exercise ring", "0")
    val exercise: Int,
    @Schema("Value of the stand ring", "0")
    val stand: Int,
) : IChildModel<LocalDate, EntryPayload, EntryPayload, String> {

    override val id: LocalDate
        get() = date

    override val parentId: String
        get() = userId

}
