package me.nathanfallet.ringify.client

import me.nathanfallet.ktorx.models.api.IAPIClient
import me.nathanfallet.ringify.repositories.auth.IAuthAPIRemoteRepository
import me.nathanfallet.ringify.repositories.duels.IDuelsRemoteRepository
import me.nathanfallet.ringify.repositories.entries.IEntriesRemoteRepository
import me.nathanfallet.ringify.repositories.notifications.INotificationTokensRemoteRepository
import me.nathanfallet.ringify.repositories.teams.ITeamsRemoteRepository
import me.nathanfallet.ringify.repositories.teams.IUsersInTeamsRemoteRepository
import me.nathanfallet.ringify.repositories.users.IUsersRemoteRepository
import me.nathanfallet.ringify.repositories.watchers.IWatchersRemoteRepository

interface IRingifyClient : IAPIClient {

    val auth: IAuthAPIRemoteRepository
    val users: IUsersRemoteRepository
    val duels: IDuelsRemoteRepository
    val entries: IEntriesRemoteRepository
    val notificationTokens: INotificationTokensRemoteRepository
    val teams: ITeamsRemoteRepository
    val usersInTeams: IUsersInTeamsRemoteRepository
    val watchers: IWatchersRemoteRepository

}
