package me.nathanfallet.ringify.repositories.users

import me.nathanfallet.ringify.models.duels.Duel
import me.nathanfallet.ringify.models.teams.UserInTeam
import me.nathanfallet.ringify.models.users.UpdateUserPayload
import me.nathanfallet.ringify.models.users.User

interface IUsersRemoteRepository {

    suspend fun get(id: String): User?
    suspend fun update(id: String, payload: UpdateUserPayload): User?
    suspend fun delete(id: String): Boolean
    suspend fun listTeams(id: String): List<UserInTeam>
    suspend fun listDuels(id: String): List<Duel>
    suspend fun listEndedDuels(id: String): List<Duel>
    suspend fun listPendingDuels(id: String): List<Duel>

}
