package me.nathanfallet.ringify.repositories.teams

import io.ktor.util.reflect.*
import me.nathanfallet.ktorx.repositories.api.APIChildModelRemoteRepository
import me.nathanfallet.ktorx.repositories.api.IAPIChildModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.teams.CreateUserInTeamPayload
import me.nathanfallet.ringify.models.teams.Team
import me.nathanfallet.ringify.models.teams.UserInTeam
import me.nathanfallet.usecases.models.id.RecursiveId

class UsersInTeamsRemoteRepository(
    client: IRingifyClient,
    parentRepository: IAPIChildModelRemoteRepository<Team, String, *, *, *>,
) : APIChildModelRemoteRepository<UserInTeam, String, CreateUserInTeamPayload, Unit, String>(
    typeInfo<UserInTeam>(),
    typeInfo<CreateUserInTeamPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<UserInTeam>>(),
    client,
    parentRepository,
    route = "users",
    prefix = "/api/v1"
), IUsersInTeamsRemoteRepository {

    override suspend fun list(teamId: String): List<UserInTeam> =
        list(RecursiveId<Team, String, Unit>(teamId), null)

    override suspend fun create(payload: CreateUserInTeamPayload, teamId: String): UserInTeam? =
        create(payload, RecursiveId<Team, String, Unit>(teamId), null)

    override suspend fun delete(userId: String, teamId: String): Boolean =
        delete(userId, RecursiveId<Team, String, Unit>(teamId), null)

}
