package me.nathanfallet.ringify.repositories.teams

import me.nathanfallet.ringify.models.duels.Duel
import me.nathanfallet.ringify.models.entries.Entry
import me.nathanfallet.ringify.models.teams.CreateTeamPayload
import me.nathanfallet.ringify.models.teams.Team
import me.nathanfallet.ringify.models.teams.UpdateTeamPayload
import me.nathanfallet.usecases.pagination.Pagination

interface ITeamsRemoteRepository {

    suspend fun list(pagination: Pagination): List<Team>
    suspend fun get(id: String): Team?
    suspend fun create(payload: CreateTeamPayload): Team?
    suspend fun update(id: String, payload: UpdateTeamPayload): Team?
    suspend fun listDuels(id: String): List<Duel>
    suspend fun listEntries(id: String, date: String): List<Entry>

}
