package me.nathanfallet.ringify.repositories.duels

import io.ktor.client.call.*
import io.ktor.http.*
import io.ktor.util.reflect.*
import me.nathanfallet.ktorx.repositories.api.APIModelRemoteRepository
import me.nathanfallet.ringify.client.IRingifyClient
import me.nathanfallet.ringify.models.duels.CreateDuelPayload
import me.nathanfallet.ringify.models.duels.Duel
import me.nathanfallet.ringify.models.duels.UpdateDuelPayload
import me.nathanfallet.ringify.models.entries.Entry
import me.nathanfallet.usecases.models.UnitModel
import me.nathanfallet.usecases.models.id.RecursiveId

class DuelsRemoteRepository(
    client: IRingifyClient,
) : APIModelRemoteRepository<Duel, String, CreateDuelPayload, UpdateDuelPayload>(
    typeInfo<Duel>(),
    typeInfo<CreateDuelPayload>(),
    typeInfo<UpdateDuelPayload>(),
    typeInfo<List<Duel>>(),
    client,
    prefix = "/api/v1"
), IDuelsRemoteRepository {

    override suspend fun get(id: String): Duel? = get(id, null)

    override suspend fun create(payload: CreateDuelPayload): Duel? = create(payload, null)

    override suspend fun accept(id: String): Duel? = client
        .request(HttpMethod.Post, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id")
        .body()

    override suspend fun decline(id: String): Boolean = delete(id, null)

    override suspend fun listEntries(id: String): List<Entry> = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/entries")
        .body()

}
