/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.core.utils;

import java.io.File;

public class FileUtil {
    public static final String DEF_LINE_SEPARATOR = "/";
    public static final String WIN_LINE_SEPARATOR = "\\";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "/n");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator", "/");

    public static boolean isExistDir(String path) {
        boolean res = false;
        File file = new File(path);
        int exist = FileUtil.isExist(file);
        if (exist < 0) {
            return FileUtil.createDir(path);
        }
        if (exist == 0) {
            res = true;
        }
        return res;
    }

    public static int isExist(String path) {
        File file = new File(path);
        return FileUtil.isExist(file);
    }

    public static int isExist(File file) {
        int res = -1;
        if (file.exists()) {
            if (file.isFile()) {
                res = 1;
            }
            if (file.isDirectory()) {
                res = 0;
            }
        }
        return res;
    }

    public static boolean createDir(String path) {
        File file = new File(path);
        return FileUtil.createDir(file);
    }

    public static boolean createDir(File file) {
        boolean res = false;
        int isF = FileUtil.isExist(file);
        if (isF < 0) {
            res = file.mkdirs();
        }
        if (isF == 0) {
            res = true;
        }
        return res;
    }

    public static String unite(String ... filePaths) {
        return FileUtil.unite(true, filePaths);
    }

    public static String unite(boolean isFilePath, String ... dirs) {
        if (null == dirs || dirs.length == 0) {
            return null;
        }
        StringBuilder pathStr = new StringBuilder();
        for (int i = 0; i < dirs.length; ++i) {
            String dir = dirs[i];
            if (dir == null || dir.isEmpty()) continue;
            pathStr.append(dir);
            String wei = dir.substring(dir.length() - 1);
            if (DEF_LINE_SEPARATOR.equals(wei) || WIN_LINE_SEPARATOR.equals(wei) || i == dirs.length - 1 && isFilePath) continue;
            pathStr.append(DEF_LINE_SEPARATOR);
        }
        return pathStr.toString();
    }
}

