/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.core.conf;

import me.meilon.jsftp.core.SftpEvictionPolicy;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class SftpPoolConfig {
    private boolean lifo = true;
    private boolean fairness = false;
    private long maxWaitMillis = -1L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = -1L;
    private int numTestsPerEvictionRun = 3;
    private String evictionPolicyClassName = SftpEvictionPolicy.class.getName();
    private boolean testOnCreate = false;
    private long timeBetweenEvictionRunsMillis = -1L;
    private boolean blockWhenExhausted = true;
    private int minIdlePerKey = 1;
    private int maxIdlePerKey = 8;
    private int maxTotalPerKey = 8;
    private int maxTotal = -1;

    public static Builder builder() {
        return new Builder();
    }

    public GenericKeyedObjectPoolConfig toGenericKeyedObjectPoolConfig() {
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotal(this.maxTotal);
        config.setMaxIdlePerKey(this.maxIdlePerKey);
        config.setMinIdlePerKey(this.minIdlePerKey);
        config.setMaxTotalPerKey(this.maxTotalPerKey);
        config.setLifo(this.lifo);
        config.setFairness(this.fairness);
        config.setMaxWaitMillis(this.maxWaitMillis);
        config.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        config.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        config.setEvictionPolicyClassName(this.evictionPolicyClassName);
        config.setTestOnCreate(this.testOnCreate);
        config.setBlockWhenExhausted(this.blockWhenExhausted);
        config.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        config.setTestWhileIdle(this.timeBetweenEvictionRunsMillis > 0L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        return config;
    }

    public boolean isLifo() {
        return this.lifo;
    }

    public boolean isFairness() {
        return this.fairness;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public int getMinIdlePerKey() {
        return this.minIdlePerKey;
    }

    public int getMaxIdlePerKey() {
        return this.maxIdlePerKey;
    }

    public int getMaxTotalPerKey() {
        return this.maxTotalPerKey;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public void setFairness(boolean fairness) {
        this.fairness = fairness;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void setEvictionPolicyClassName(String evictionPolicyClassName) {
        this.evictionPolicyClassName = evictionPolicyClassName;
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public void setMinIdlePerKey(int minIdlePerKey) {
        this.minIdlePerKey = minIdlePerKey;
    }

    public void setMaxIdlePerKey(int maxIdlePerKey) {
        this.maxIdlePerKey = maxIdlePerKey;
    }

    public void setMaxTotalPerKey(int maxTotalPerKey) {
        this.maxTotalPerKey = maxTotalPerKey;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public static class Builder {
        private final SftpPoolConfig config = new SftpPoolConfig();

        public Builder setLifo(boolean lifo) {
            this.config.setLifo(lifo);
            return this;
        }

        public Builder setFairness(boolean fairness) {
            this.config.setFairness(fairness);
            return this;
        }

        public Builder setMaxWaitMillis(long maxWaitMillis) {
            this.config.setMaxWaitMillis(maxWaitMillis);
            return this;
        }

        public Builder setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.config.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
            return this;
        }

        public Builder setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
            this.config.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
            return this;
        }

        public Builder setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
            this.config.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
            return this;
        }

        public Builder setEvictionPolicyClassName(String evictionPolicyClassName) {
            this.config.setEvictionPolicyClassName(evictionPolicyClassName);
            return this;
        }

        public Builder setTestOnCreate(boolean testOnCreate) {
            this.config.setTestOnCreate(testOnCreate);
            return this;
        }

        public Builder setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
            this.config.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
            return this;
        }

        public Builder setBlockWhenExhausted(boolean blockWhenExhausted) {
            this.config.setBlockWhenExhausted(blockWhenExhausted);
            return this;
        }

        public Builder setMinIdlePerKey(int minIdlePerKey) {
            this.config.setMinIdlePerKey(minIdlePerKey);
            return this;
        }

        public Builder setMaxIdlePerKey(int maxIdlePerKey) {
            this.config.setMaxIdlePerKey(maxIdlePerKey);
            return this;
        }

        public Builder setMaxTotalPerKey(int maxTotalPerKey) {
            this.config.setMaxTotalPerKey(maxTotalPerKey);
            return this;
        }

        public Builder setMaxTotal(int maxTotal) {
            this.config.setMaxTotal(maxTotal);
            return this;
        }

        public SftpPoolConfig build() {
            return this.config;
        }
    }
}

