/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.core.conf;

public class SftpConnConfig {
    private final String id;
    private final String host;
    private final int port;
    private final String userName;
    private final String password;
    private final String alias;
    private String basePath;
    private boolean autoDisconnect = false;

    public SftpConnConfig(String host, int port, String userName, String password) {
        this(host, port, userName, password, null);
    }

    public SftpConnConfig(String host, int port, String userName, String password, String id) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.alias = userName + "@" + host + ":" + port;
        this.id = id != null && !id.isEmpty() ? id : this.alias;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean isAutoDisconnect() {
        return this.autoDisconnect;
    }

    public void setAutoDisconnect(boolean autoDisconnect) {
        this.autoDisconnect = autoDisconnect;
    }

    public String toString() {
        return "SftpConnConfig{host='" + this.host + '\'' + ", port=" + this.port + ", userName='" + this.userName + '\'' + ", password='" + this.password + '\'' + ", homePath='" + this.basePath + '\'' + ", id='" + this.id + '\'' + '}';
    }
}

