/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.core;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import me.meilon.jsftp.core.SftpConnect;
import me.meilon.jsftp.core.SftpPool;
import me.meilon.jsftp.core.SftpPooledObject;
import me.meilon.jsftp.core.conf.SftpConnConfig;
import me.meilon.jsftp.core.conf.SftpPoolConfig;
import me.meilon.jsftp.core.exception.SftpConfigException;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SftpPooledFactory
extends BaseKeyedPooledObjectFactory<String, SftpConnect> {
    private static final Logger log = LoggerFactory.getLogger(SftpPooledFactory.class);
    private final Map<String, SftpConnConfig> connConfigMap;
    private SftpPoolConfig sftpPoolConfig;
    private static volatile SftpPool pool;

    public SftpPooledFactory(int size) {
        this.connConfigMap = new ConcurrentHashMap<String, SftpConnConfig>(size);
    }

    public SftpPooledFactory() {
        this(16);
    }

    public SftpPooledFactory(SftpPoolConfig sftpPoolConfig) {
        this();
        this.sftpPoolConfig = sftpPoolConfig;
    }

    public SftpPooledFactory(Map<String, SftpConnConfig> connConfigMap) {
        this(connConfigMap.size());
        this.setSftpConnConfigMap(connConfigMap);
    }

    public SftpPooledFactory(Map<String, SftpConnConfig> connConfigMap, SftpPoolConfig sftpPoolConfig) {
        this(connConfigMap);
        this.sftpPoolConfig = sftpPoolConfig;
    }

    public static SftpConnect createConnect(String host, Integer port, String user, String password) throws JSchException {
        return SftpPooledFactory.createConnect(host, port, user, password, null);
    }

    private static SftpConnect createConnect(String host, Integer port, String user, String password, String id) throws JSchException {
        JSch jsch = new JSch();
        Properties sshConfig = new Properties();
        sshConfig.put("StrictHostKeyChecking", "no");
        Session session = jsch.getSession(user, host, port.intValue());
        session.setPassword(password);
        session.setConfig(sshConfig);
        session.connect();
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        channel.connect();
        SftpConnConfig conf = new SftpConnConfig(host, port, user, password, id);
        return new SftpConnect(conf, channel, session);
    }

    public static void closeSftp(SftpConnect sftpConnect) {
        if (sftpConnect == null) {
            return;
        }
        if (!sftpConnect.isPooledObject() || pool == null || sftpConnect.getId() == null) {
            sftpConnect.disconnect();
            return;
        }
        pool.returnSftp(sftpConnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SftpPool getSftpPool() {
        if (pool != null) return pool;
        Class<SftpPool> clazz = SftpPool.class;
        synchronized (SftpPool.class) {
            if (pool != null) return pool;
            if (this.sftpPoolConfig == null) {
                log.info("use def SftpPoolConfig");
                this.sftpPoolConfig = new SftpPoolConfig();
            }
            pool = new SftpPool(this, this.sftpPoolConfig.toGenericKeyedObjectPoolConfig());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return pool;
        }
    }

    public SftpConnConfig setSftpConnConfig(String host, Integer port, String user, String password) {
        SftpConnConfig conf = new SftpConnConfig(host, port, user, password);
        this.setSftpConnConfig(conf);
        return conf;
    }

    public SftpConnConfig setSftpConnConfig(String host, Integer port, String user, String password, String sftpId) {
        SftpConnConfig conf = new SftpConnConfig(host, port, user, password, sftpId);
        this.setSftpConnConfig(conf);
        return conf;
    }

    public SftpConnConfig setSftpConnConfig(String host, Integer port, String user, String password, boolean autoDisconnect) {
        SftpConnConfig conf = new SftpConnConfig(host, port, user, password);
        conf.setAutoDisconnect(autoDisconnect);
        this.setSftpConnConfig(conf);
        return conf;
    }

    public SftpConnConfig setSftpConnConfig(String host, Integer port, String user, String password, String sftpId, boolean autoDisconnect) {
        SftpConnConfig conf = new SftpConnConfig(host, port, user, password, sftpId);
        conf.setAutoDisconnect(autoDisconnect);
        this.setSftpConnConfig(conf);
        return conf;
    }

    public void setSftpConnConfig(SftpConnConfig config) {
        if (config == null) {
            throw new NullPointerException("SftpConnConfig is null!");
        }
        String key = config.getId();
        SftpConnConfig oldConf = this.connConfigMap.get(key);
        if (oldConf != null && oldConf.getPassword().equals(config.getPassword())) {
            return;
        }
        this.connConfigMap.put(key, config);
    }

    public void setSftpConnConfigMap(Map<String, SftpConnConfig> configMap) {
        this.connConfigMap.putAll(configMap);
    }

    public SftpConnConfig getSftpConnConf(String sftpId) {
        return this.connConfigMap.get(sftpId);
    }

    public SftpConnect create(String sftpId) throws Exception {
        SftpConnConfig conf = this.connConfigMap.get(sftpId);
        if (conf == null) {
            throw new SftpConfigException("get sftpConfig is null! ");
        }
        SftpConnect connect = SftpPooledFactory.createConnect(conf.getHost(), conf.getPort(), conf.getUserName(), conf.getPassword(), sftpId);
        String homePath = conf.getBasePath();
        if (homePath == null) {
            homePath = connect.getHome();
            conf.setBasePath(homePath);
        }
        return connect;
    }

    public PooledObject<SftpConnect> wrap(SftpConnect value) {
        value.setPooledObject(true);
        return new SftpPooledObject(value);
    }

    public boolean validateObject(String sftpId, PooledObject<SftpConnect> p) {
        boolean res = false;
        if (p != null) {
            SftpConnConfig config = this.connConfigMap.get(sftpId);
            if (config.isAutoDisconnect() && PooledObjectState.RETURNING == p.getState()) {
                return false;
            }
            SftpConnect bean = (SftpConnect)p.getObject();
            if (bean != null) {
                res = bean.isConnected();
            }
            log.debug("validateSftp {} {}={}, NumActive {}, NumIdle {}", new Object[]{p.getState(), sftpId, res, pool.getNumActive(sftpId), pool.getNumIdle(sftpId)});
        }
        return res;
    }

    public void destroyObject(String sftpId, PooledObject<SftpConnect> p) throws Exception {
        if (p != null) {
            SftpConnect sftp = (SftpConnect)p.getObject();
            if (sftp != null) {
                sftp.disconnect();
            }
            log.debug("destroySftp {}, NumActive {}, NumIdle {}", new Object[]{sftpId, pool.getNumActive(sftpId), pool.getNumIdle(sftpId)});
            super.destroyObject((Object)sftpId, p);
        }
    }

    public void activateObject(String sftpId, PooledObject<SftpConnect> p) throws Exception {
        super.activateObject((Object)sftpId, p);
    }

    public void passivateObject(String sftpId, PooledObject<SftpConnect> p) throws Exception {
        SftpConnect conn = (SftpConnect)p.getObject();
        SftpConnConfig config = this.connConfigMap.get(sftpId);
        String homePath = config.getBasePath();
        if (homePath != null) {
            conn.cd(homePath);
        }
        log.debug("passivateObject {}", (Object)sftpId);
        super.passivateObject((Object)sftpId, p);
    }
}

