/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.core;

import me.meilon.jsftp.core.SftpConnect;
import me.meilon.jsftp.core.SftpPooledFactory;
import me.meilon.jsftp.core.conf.SftpConnConfig;
import me.meilon.jsftp.core.exception.SftpConfigException;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class SftpPool
extends GenericKeyedObjectPool<String, SftpConnect> {
    protected SftpPool(SftpPooledFactory factory, GenericKeyedObjectPoolConfig config) {
        super((KeyedPooledObjectFactory)factory, config);
    }

    public SftpConnect borrowObject(SftpConnConfig config) throws Exception {
        String key;
        if (config == null) {
            throw new NullPointerException("SftpConnConfig is null");
        }
        SftpPooledFactory factory = (SftpPooledFactory)this.getFactory();
        SftpConnConfig defConfig = factory.getSftpConnConf(key = config.getId());
        if (defConfig == null || !defConfig.getPassword().equals(config.getPassword())) {
            factory.setSftpConnConfig(config);
        }
        return this.borrowObject(key);
    }

    public SftpConnect borrowObject(String host, Integer port, String user, String password) throws Exception {
        SftpPooledFactory factory = (SftpPooledFactory)this.getFactory();
        SftpConnConfig conf = new SftpConnConfig(host, port, user, password);
        factory.setSftpConnConfig(conf);
        return this.borrowObject(conf.getId());
    }

    public SftpConnect borrowObject(String sftpId) throws Exception {
        SftpPooledFactory factory = (SftpPooledFactory)this.getFactory();
        SftpConnConfig defConfig = factory.getSftpConnConf(sftpId);
        if (defConfig == null) {
            throw new SftpConfigException("SftpConnConfig is null");
        }
        return (SftpConnect)super.borrowObject((Object)sftpId);
    }

    public void invalidateObject(String sftpId, SftpConnect sftpConnect) throws Exception {
        if (sftpConnect != null && sftpConnect.isConnected()) {
            sftpConnect.disconnect();
        }
        super.invalidateObject((Object)sftpId, (Object)sftpConnect);
    }

    public void invalidateSftp(SftpConnect sftpConnect) throws Exception {
        if (sftpConnect != null && sftpConnect.isConnected()) {
            sftpConnect.disconnect();
            super.invalidateObject((Object)sftpConnect.getId(), (Object)sftpConnect);
        }
    }

    public void returnSftp(SftpConnect sftpConnect) {
        this.returnObject(sftpConnect.getId(), sftpConnect);
    }

    public int getNumActive() {
        return super.getNumActive();
    }

    public int getNumActive(String sftpId) {
        return super.getNumActive((Object)sftpId);
    }

    public int getNumIdle() {
        return super.getNumIdle();
    }

    public int getNumIdle(String sftpId) {
        return super.getNumIdle((Object)sftpId);
    }

    public void clear() {
        super.clear();
    }

    public void clear(String sftpId) {
        super.clear((Object)sftpId);
    }

    public void close() {
        super.close();
    }
}

