/*
 * Decompiled with CFR 0.152.
 */
package me.meilon.jsftp.core;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import me.meilon.jsftp.core.SftpPooledFactory;
import me.meilon.jsftp.core.conf.SftpConnConfig;
import me.meilon.jsftp.core.conf.SftpMode;
import me.meilon.jsftp.core.exception.SftpRunException;
import me.meilon.jsftp.core.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpConnect
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SftpConnect.class);
    private final ChannelSftp sftp;
    private final Session session;
    private final SftpConnConfig config;
    private boolean isPooledObject = false;
    private static final String NO_SUCH_FILE = "no such file";

    protected SftpConnect(SftpConnConfig config, ChannelSftp sftp, Session session) {
        this.config = config;
        this.sftp = sftp;
        this.session = session;
    }

    public boolean isPooledObject() {
        return this.isPooledObject;
    }

    protected void setPooledObject(boolean pooledObject) {
        this.isPooledObject = pooledObject;
    }

    public String getId() {
        return this.config.getId();
    }

    public ChannelSftp getChannelSftp() {
        return this.sftp;
    }

    public boolean isConnected() {
        return this.sftp.isConnected();
    }

    public boolean isDir(String directory) throws SftpException {
        SftpATTRS attrs = this.getAttrs(directory);
        if (attrs == null) {
            return false;
        }
        return attrs.isDir();
    }

    public boolean isFile(String filePath) throws SftpException {
        SftpATTRS attrs = this.getAttrs(filePath);
        if (attrs == null) {
            return false;
        }
        return !attrs.isDir() && !attrs.isLink();
    }

    public boolean isExist(String path) throws SftpException {
        SftpATTRS attrs = this.getAttrs(path);
        return attrs != null;
    }

    public SftpATTRS getAttrs(String path) throws SftpException {
        try {
            return this.sftp.lstat(path);
        }
        catch (SftpException e) {
            if (NO_SUCH_FILE.equalsIgnoreCase(e.getMessage())) {
                return null;
            }
            throw e;
        }
    }

    public String pwd() throws SftpException {
        return this.sftp.pwd();
    }

    public String getHome() throws SftpException {
        return this.sftp.getHome();
    }

    public void rmdir(String remotePath) throws SftpException {
        this.sftp.rmdir(remotePath);
    }

    public void mkdir(String directory) throws SftpException {
        if (!this.isDir(directory)) {
            this.sftp.mkdir(directory);
        }
    }

    public void mkdirs(String createPath) throws SftpException {
        if (this.isDir(createPath)) {
            return;
        }
        String[] pathArry = createPath.trim().split("/");
        StringBuilder filePath = pathArry[0].isEmpty() ? new StringBuilder("/") : new StringBuilder();
        for (String pathNode : pathArry) {
            if (pathNode == null || pathNode.isEmpty()) continue;
            filePath.append(pathNode);
            String path = filePath.toString();
            this.mkdir(path);
            filePath.append("/");
        }
    }

    public void chmod(int permsion, String directory) throws SftpException {
        this.sftp.chmod(permsion, directory);
    }

    public void chown(int uid, String path) throws SftpException {
        this.sftp.chown(uid, path);
    }

    public void rename(String oldpath, String newpath) throws SftpException {
        this.sftp.rename(oldpath, newpath);
    }

    public void cd(String path) throws SftpException {
        this.sftp.cd(path);
    }

    public void openDir(String directory) throws SftpException {
        if (directory == null || directory.isEmpty()) {
            throw new NullPointerException("directory is null");
        }
        if (!this.isDir(directory)) {
            this.mkdirs(directory);
        }
        this.sftp.cd(directory);
    }

    public void chgrp(Integer gid, String path) throws SftpException {
        this.sftp.chgrp(gid.intValue(), path);
    }

    public void delete(String deleteFile) throws SftpException {
        this.sftp.rm(deleteFile);
    }

    public void delete(String directory, String deleteFile) throws SftpException {
        String pwd = this.pwd();
        this.sftp.cd(directory);
        this.sftp.rm(deleteFile);
        this.sftp.cd(pwd);
    }

    public void uploadFile(String filePath, String remotePath) throws SftpException {
        remotePath = this.remoteAbsolutePath(filePath, remotePath);
        this.sftp.put(filePath, remotePath);
    }

    public void uploadFile(String filePath, String remotePath, SftpMode mode) throws SftpException {
        remotePath = this.remoteAbsolutePath(filePath, remotePath);
        this.sftp.put(filePath, remotePath, mode.getMode());
    }

    public void uploadFile(String filePath, String remotePath, SftpProgressMonitor monitor) throws SftpException {
        remotePath = this.remoteAbsolutePath(filePath, remotePath);
        this.sftp.put(filePath, remotePath, monitor);
    }

    public void uploadFile(InputStream fileIo, String remoteFilePath) throws SftpException {
        if (this.isDir(remoteFilePath)) {
            throw new SftpRunException(remoteFilePath + " is directory");
        }
        this.sftp.put(fileIo, remoteFilePath);
    }

    public OutputStream uploadFile(String remoteFilePath) throws SftpException {
        if (this.isDir(remoteFilePath)) {
            throw new SftpRunException(remoteFilePath + " is directory");
        }
        return this.sftp.put(remoteFilePath);
    }

    public void uploadFile(File localFile, String remoteFilePath) throws SftpException {
        if (!localFile.isFile()) {
            throw new SftpRunException(localFile + " is not found");
        }
        try {
            FileInputStream in = new FileInputStream(localFile);
            this.sftp.put((InputStream)in, remoteFilePath);
        }
        catch (FileNotFoundException e) {
            throw new SftpRunException(e);
        }
    }

    public void uploadFiles(String directory, String remoteDir) throws SftpException {
        this.uploadFiles(directory, remoteDir, null);
    }

    public void uploadFiles(String directory, String remoteDir, FileFilter filter) throws SftpException {
        File filePath = new File(directory);
        if (!filePath.isDirectory() || !filePath.exists()) {
            throw new SftpRunException(directory + "is not directory");
        }
        if (!this.isDir(remoteDir)) {
            throw new SftpRunException(remoteDir + "is not directory");
        }
        File[] files = filter == null ? filePath.listFiles() : filePath.listFiles(filter);
        if (files != null && files.length > 0) {
            for (File file : files) {
                this.uploadFile(file, remoteDir);
            }
        }
    }

    public void download(String remoteFilePath, String localFilePath) throws SftpException {
        this.sftp.get(remoteFilePath, localFilePath);
    }

    public InputStream openFile(String filePath) throws SftpException {
        return this.sftp.get(filePath);
    }

    public boolean downloadAsnFile(String remotePath, String fileName, String savePath, String suffixPattren) {
        try {
            File fileDir = new File(savePath);
            if (!fileDir.exists() && fileDir.mkdirs()) {
                String remoteFile = FileUtil.unite(remotePath, fileName);
                String tempFileName = FileUtil.unite(savePath, fileName + suffixPattren);
                this.sftp.get(remoteFile, tempFileName);
                File tempFile = new File(tempFileName);
                File file = new File(FileUtil.unite(savePath, fileName));
                return tempFile.renameTo(file);
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        return false;
    }

    public List<String> listFileNames(String remotePath) throws SftpException {
        ArrayList<String> ftpFileNameList = new ArrayList<String>();
        if (remotePath != null && !remotePath.isEmpty()) {
            this.sftp.ls(remotePath, lsEntry -> {
                if (lsEntry == null) {
                    return 1;
                }
                String fileName = lsEntry.getFilename();
                if (fileName != null && !".".equals(fileName) && !"..".equals(fileName)) {
                    ftpFileNameList.add(lsEntry.getFilename());
                }
                return 0;
            });
        }
        return ftpFileNameList;
    }

    public List<ChannelSftp.LsEntry> listFiles(String remotePath) throws SftpException {
        if (remotePath == null || remotePath.isEmpty()) {
            throw new IllegalAccessError("directory is null!");
        }
        return this.sftp.ls(remotePath);
    }

    public void listFiles(String remotePath, ChannelSftp.LsEntrySelector selector) throws SftpException {
        if (remotePath == null || remotePath.isEmpty()) {
            throw new IllegalAccessError("directory is null!");
        }
        this.sftp.ls(remotePath, selector);
    }

    public void copyfile(String fromPath, String toPath, String fileName) throws SftpException {
        String formFilePath = FileUtil.unite(fromPath, fileName);
        String toFilePath = FileUtil.unite(toPath, fileName);
        this.copyfile(formFilePath, toFilePath);
    }

    public void copyfile(String fromFilePath, String toFilePath) throws SftpException {
        InputStream nInputStream = null;
        try (ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
             InputStream tInputStream = this.openFile(fromFilePath);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = tInputStream.read(buffer)) > -1) {
                outBuffer.write(buffer, 0, len);
            }
            outBuffer.flush();
            nInputStream = new ByteArrayInputStream(outBuffer.toByteArray());
            this.uploadFile(nInputStream, toFilePath);
        }
        catch (IOException e) {
            throw new SftpRunException(e);
        }
        finally {
            try {
                if (null != nInputStream) {
                    nInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void disconnect() {
        this.sftp.disconnect();
        this.session.disconnect();
    }

    @Override
    public void close() {
        SftpPooledFactory.closeSftp(this);
    }

    private String remoteAbsolutePath(String filePath, String remotePath) throws SftpException {
        boolean isDir = remotePath.endsWith("/");
        if (isDir || this.isDir(remotePath)) {
            File file = new File(filePath);
            String filename = file.getName();
            remotePath = isDir ? remotePath + filename : remotePath + "/" + filename;
        }
        return remotePath;
    }
}

