/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package me.meeco.holder.wallet.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import me.meeco.holder.wallet.models.CreateWalletPayloadDto
import me.meeco.holder.wallet.models.InvalidPathParamError
import me.meeco.holder.wallet.models.InvalidRequestPayloadError
import me.meeco.holder.wallet.models.WalletNotFoundError
import me.meeco.holder.wallet.models.WalletResponseDto
import me.meeco.holder.wallet.models.WalletsControllerCreate500Response
import me.meeco.holder.wallet.models.WalletsControllerDeleteOne500Response
import me.meeco.holder.wallet.models.WalletsControllerGetOne500Response

import com.squareup.moshi.Json

import me.meeco.holder.wallet.infrastructure.ApiClient
import me.meeco.holder.wallet.infrastructure.ApiResponse
import me.meeco.holder.wallet.infrastructure.ClientException
import me.meeco.holder.wallet.infrastructure.ClientError
import me.meeco.holder.wallet.infrastructure.ServerException
import me.meeco.holder.wallet.infrastructure.ServerError
import me.meeco.holder.wallet.infrastructure.MultiValueMap
import me.meeco.holder.wallet.infrastructure.PartConfig
import me.meeco.holder.wallet.infrastructure.RequestConfig
import me.meeco.holder.wallet.infrastructure.RequestMethod
import me.meeco.holder.wallet.infrastructure.ResponseType
import me.meeco.holder.wallet.infrastructure.Success
import me.meeco.holder.wallet.infrastructure.toMultiValue

class WalletApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://holder-wallet-dev.svx.internal")
        }
    }

    /**
     * Register or find a Wallet
     * Register a new Wallet. Optionally use &#x60;external_reference&#x60;. When a Wallet exists with the given &#x60;external_reference&#x60;, the existing Wallet information is returned making the operation idempotent. If &#x60;external_reference&#x60; is not used a new Wallet is always created.  Based on the configuration of the component, a Wallet has a default key and DID assigned to it. This key and DID are used to register and authenticate the Wallet with the SVX API. 
     * @param createWalletPayloadDto 
     * @return WalletResponseDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun walletsControllerCreate(createWalletPayloadDto: CreateWalletPayloadDto) : WalletResponseDto {
        val localVarResponse = walletsControllerCreateWithHttpInfo(createWalletPayloadDto = createWalletPayloadDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as WalletResponseDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Register or find a Wallet
     * Register a new Wallet. Optionally use &#x60;external_reference&#x60;. When a Wallet exists with the given &#x60;external_reference&#x60;, the existing Wallet information is returned making the operation idempotent. If &#x60;external_reference&#x60; is not used a new Wallet is always created.  Based on the configuration of the component, a Wallet has a default key and DID assigned to it. This key and DID are used to register and authenticate the Wallet with the SVX API. 
     * @param createWalletPayloadDto 
     * @return ApiResponse<WalletResponseDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun walletsControllerCreateWithHttpInfo(createWalletPayloadDto: CreateWalletPayloadDto) : ApiResponse<WalletResponseDto?> {
        val localVariableConfig = walletsControllerCreateRequestConfig(createWalletPayloadDto = createWalletPayloadDto)

        return request<CreateWalletPayloadDto, WalletResponseDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation walletsControllerCreate
     *
     * @param createWalletPayloadDto 
     * @return RequestConfig
     */
    fun walletsControllerCreateRequestConfig(createWalletPayloadDto: CreateWalletPayloadDto) : RequestConfig<CreateWalletPayloadDto> {
        val localVariableBody = createWalletPayloadDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete Wallet by ID
     * Deleted Wallet by ID. All information stored inside the Wallet will be deleted as well.
     * @param walletId 
     * @return void
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun walletsControllerDeleteOne(walletId: kotlin.String) : Unit {
        val localVarResponse = walletsControllerDeleteOneWithHttpInfo(walletId = walletId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete Wallet by ID
     * Deleted Wallet by ID. All information stored inside the Wallet will be deleted as well.
     * @param walletId 
     * @return ApiResponse<Unit?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Throws(IllegalStateException::class, IOException::class)
    fun walletsControllerDeleteOneWithHttpInfo(walletId: kotlin.String) : ApiResponse<Unit?> {
        val localVariableConfig = walletsControllerDeleteOneRequestConfig(walletId = walletId)

        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation walletsControllerDeleteOne
     *
     * @param walletId 
     * @return RequestConfig
     */
    fun walletsControllerDeleteOneRequestConfig(walletId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/wallets/{walletId}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get Wallet by ID
     * Fetch Wallet information by ID.
     * @param walletId 
     * @return WalletResponseDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun walletsControllerGetOne(walletId: kotlin.String) : WalletResponseDto {
        val localVarResponse = walletsControllerGetOneWithHttpInfo(walletId = walletId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as WalletResponseDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get Wallet by ID
     * Fetch Wallet information by ID.
     * @param walletId 
     * @return ApiResponse<WalletResponseDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun walletsControllerGetOneWithHttpInfo(walletId: kotlin.String) : ApiResponse<WalletResponseDto?> {
        val localVariableConfig = walletsControllerGetOneRequestConfig(walletId = walletId)

        return request<Unit, WalletResponseDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation walletsControllerGetOne
     *
     * @param walletId 
     * @return RequestConfig
     */
    fun walletsControllerGetOneRequestConfig(walletId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/{walletId}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
