/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package me.meeco.holder.wallet.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import me.meeco.holder.wallet.models.CredentialReceiveGetAccessTokenRequestModelDto
import me.meeco.holder.wallet.models.CredentialReceiveGetAccessTokenResponseModelDto
import me.meeco.holder.wallet.models.CredentialReceiveGetCredentialRequestModelDto
import me.meeco.holder.wallet.models.CredentialReceiveGetCredentialResponseModelDto
import me.meeco.holder.wallet.models.CredentialReceiveRequestModelDto
import me.meeco.holder.wallet.models.CredentialReceiveResponseModelDto
import me.meeco.holder.wallet.models.CredentialReceiveStateModelDto
import me.meeco.holder.wallet.models.CredentialReceiveStatesModelDto
import me.meeco.holder.wallet.models.DeleteReceiveStateError
import me.meeco.holder.wallet.models.ReceiveControllerCreate400Response
import me.meeco.holder.wallet.models.ReceiveControllerFindAll400Response
import me.meeco.holder.wallet.models.ReceiveControllerFindAll500Response
import me.meeco.holder.wallet.models.ReceiveControllerGetInfo500Response
import me.meeco.holder.wallet.models.WalletNotFoundError

import com.squareup.moshi.Json

import me.meeco.holder.wallet.infrastructure.ApiClient
import me.meeco.holder.wallet.infrastructure.ApiResponse
import me.meeco.holder.wallet.infrastructure.ClientException
import me.meeco.holder.wallet.infrastructure.ClientError
import me.meeco.holder.wallet.infrastructure.ServerException
import me.meeco.holder.wallet.infrastructure.ServerError
import me.meeco.holder.wallet.infrastructure.MultiValueMap
import me.meeco.holder.wallet.infrastructure.PartConfig
import me.meeco.holder.wallet.infrastructure.RequestConfig
import me.meeco.holder.wallet.infrastructure.RequestMethod
import me.meeco.holder.wallet.infrastructure.ResponseType
import me.meeco.holder.wallet.infrastructure.Success
import me.meeco.holder.wallet.infrastructure.toMultiValue

class VerifiableCredentialIssuanceApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://holder-wallet-dev.svx.internal")
        }
    }

    /**
     * authorization_code flow Holder Wallet redirect uri 
     * &#x60;authorization_code&#x60; redirect uri that was started via &#x60;/receive&#x60; endpoint.&lt;br/&gt; &#x60;state&#x60; and &#x60;code&#x60; come as a query parameters.&lt;br/&gt; &#x60;code&#x60; is exchanged for the &#x60;access_token&#x60; so client can call &#x60;POST /wallets/{walletId}/receive/get_credential&#x60; endpoint right away. 
     * @param error Error code (optional)
     * @param errorDescription Error description (optional)
     * @param errorUri Error URI (optional)
     * @param code Authorization code (optional)
     * @param state Authorization state (optional)
     * @param iss Access token issuer (optional)
     * @return void
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerCallback(error: kotlin.String? = null, errorDescription: kotlin.String? = null, errorUri: kotlin.String? = null, code: kotlin.String? = null, state: kotlin.String? = null, iss: kotlin.String? = null) : Unit {
        val localVarResponse = receiveControllerCallbackWithHttpInfo(error = error, errorDescription = errorDescription, errorUri = errorUri, code = code, state = state, iss = iss)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * authorization_code flow Holder Wallet redirect uri 
     * &#x60;authorization_code&#x60; redirect uri that was started via &#x60;/receive&#x60; endpoint.&lt;br/&gt; &#x60;state&#x60; and &#x60;code&#x60; come as a query parameters.&lt;br/&gt; &#x60;code&#x60; is exchanged for the &#x60;access_token&#x60; so client can call &#x60;POST /wallets/{walletId}/receive/get_credential&#x60; endpoint right away. 
     * @param error Error code (optional)
     * @param errorDescription Error description (optional)
     * @param errorUri Error URI (optional)
     * @param code Authorization code (optional)
     * @param state Authorization state (optional)
     * @param iss Access token issuer (optional)
     * @return ApiResponse<Unit?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerCallbackWithHttpInfo(error: kotlin.String?, errorDescription: kotlin.String?, errorUri: kotlin.String?, code: kotlin.String?, state: kotlin.String?, iss: kotlin.String?) : ApiResponse<Unit?> {
        val localVariableConfig = receiveControllerCallbackRequestConfig(error = error, errorDescription = errorDescription, errorUri = errorUri, code = code, state = state, iss = iss)

        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerCallback
     *
     * @param error Error code (optional)
     * @param errorDescription Error description (optional)
     * @param errorUri Error URI (optional)
     * @param code Authorization code (optional)
     * @param state Authorization state (optional)
     * @param iss Access token issuer (optional)
     * @return RequestConfig
     */
    fun receiveControllerCallbackRequestConfig(error: kotlin.String?, errorDescription: kotlin.String?, errorUri: kotlin.String?, code: kotlin.String?, state: kotlin.String?, iss: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (error != null) {
                    put("error", listOf(error.toString()))
                }
                if (errorDescription != null) {
                    put("error_description", listOf(errorDescription.toString()))
                }
                if (errorUri != null) {
                    put("error_uri", listOf(errorUri.toString()))
                }
                if (code != null) {
                    put("code", listOf(code.toString()))
                }
                if (state != null) {
                    put("state", listOf(state.toString()))
                }
                if (iss != null) {
                    put("iss", listOf(iss.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        
        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/receive/callback",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Register credential offer
     * Credential offer is a JSON encoded object that the issuer uses to pass information to the wallet and initiate the issuance process. This endpoint is used to validate, parse and extract the necessary information, leading to the next step in the process, getting an access token.  For more information on the structure of the credential offer object, see section 4.1 in OpenID4VCI.  The three supported methods for registering a credential offer are: - &#x60;credential_offer&#x60;: Pass the JSON object by value - &#x60;credential_offer_uri&#x60;: Pass the JSON object by reference. The service performs a GET request to retrieve the object. - &#x60;credential_offer_endpoint&#x60; - Credential Offer sent by the issuer to the wallet credential offer endpoint. It contains a single URI query parameter, either credential_offer or credential_offer_uri  Note that the options above are mutually exclusive.  After successfully registering the credential offer, a state is returned. This state is used as an identifier to link subsequent calls to receive endpoints.  ### Next Step  To continue the issuance process, call:  &#x60;&#x60;&#x60;POST /wallets/{walletId}/receive/get_access_token&#x60;&#x60;&#x60; 
     * @param walletId 
     * @param credentialReceiveRequestModelDto 
     * @return CredentialReceiveResponseModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerCreate(walletId: kotlin.String, credentialReceiveRequestModelDto: CredentialReceiveRequestModelDto) : CredentialReceiveResponseModelDto {
        val localVarResponse = receiveControllerCreateWithHttpInfo(walletId = walletId, credentialReceiveRequestModelDto = credentialReceiveRequestModelDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CredentialReceiveResponseModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Register credential offer
     * Credential offer is a JSON encoded object that the issuer uses to pass information to the wallet and initiate the issuance process. This endpoint is used to validate, parse and extract the necessary information, leading to the next step in the process, getting an access token.  For more information on the structure of the credential offer object, see section 4.1 in OpenID4VCI.  The three supported methods for registering a credential offer are: - &#x60;credential_offer&#x60;: Pass the JSON object by value - &#x60;credential_offer_uri&#x60;: Pass the JSON object by reference. The service performs a GET request to retrieve the object. - &#x60;credential_offer_endpoint&#x60; - Credential Offer sent by the issuer to the wallet credential offer endpoint. It contains a single URI query parameter, either credential_offer or credential_offer_uri  Note that the options above are mutually exclusive.  After successfully registering the credential offer, a state is returned. This state is used as an identifier to link subsequent calls to receive endpoints.  ### Next Step  To continue the issuance process, call:  &#x60;&#x60;&#x60;POST /wallets/{walletId}/receive/get_access_token&#x60;&#x60;&#x60; 
     * @param walletId 
     * @param credentialReceiveRequestModelDto 
     * @return ApiResponse<CredentialReceiveResponseModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerCreateWithHttpInfo(walletId: kotlin.String, credentialReceiveRequestModelDto: CredentialReceiveRequestModelDto) : ApiResponse<CredentialReceiveResponseModelDto?> {
        val localVariableConfig = receiveControllerCreateRequestConfig(walletId = walletId, credentialReceiveRequestModelDto = credentialReceiveRequestModelDto)

        return request<CredentialReceiveRequestModelDto, CredentialReceiveResponseModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerCreate
     *
     * @param walletId 
     * @param credentialReceiveRequestModelDto 
     * @return RequestConfig
     */
    fun receiveControllerCreateRequestConfig(walletId: kotlin.String, credentialReceiveRequestModelDto: CredentialReceiveRequestModelDto) : RequestConfig<CredentialReceiveRequestModelDto> {
        val localVariableBody = credentialReceiveRequestModelDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/receive".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete receive credential state
     * Delete state of a receive credential flow. 
     * @param walletId 
     * @param state 
     * @return void
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerDeleteOne(walletId: kotlin.String, state: kotlin.String) : Unit {
        val localVarResponse = receiveControllerDeleteOneWithHttpInfo(walletId = walletId, state = state)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete receive credential state
     * Delete state of a receive credential flow. 
     * @param walletId 
     * @param state 
     * @return ApiResponse<Unit?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerDeleteOneWithHttpInfo(walletId: kotlin.String, state: kotlin.String) : ApiResponse<Unit?> {
        val localVariableConfig = receiveControllerDeleteOneRequestConfig(walletId = walletId, state = state)

        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerDeleteOne
     *
     * @param walletId 
     * @param state 
     * @return RequestConfig
     */
    fun receiveControllerDeleteOneRequestConfig(walletId: kotlin.String, state: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/wallets/{walletId}/receive/{state}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"state"+"}", encodeURIComponent(state.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter order
     */
     enum class OrderReceiveControllerFindAll(val value: kotlin.String) {
         @Json(name = "ASC") aSC("ASC"),
         @Json(name = "DESC") dESC("DESC")
     }

    /**
     * enum for parameter orderBy
     */
     enum class OrderByReceiveControllerFindAll(val value: kotlin.String) {
         @Json(name = "created_at") createdAt("created_at")
     }

    /**
     * Get credential receive states
     * 
     * @param walletId 
     * @param order Issuance state response order. Default ordering: &#x60;DESC&#x60; (Supported: &#x60;ASC&#x60;, &#x60;DESC&#x60;) (optional)
     * @param orderBy Order Issuance state by an attribute, defaults to: &#x60;created_at&#x60; (Supported: &#x60;created_at&#x60;) (optional)
     * @param perPage Number of records per page (optional)
     * @param page Page number (starting from 1) (optional)
     * @return CredentialReceiveStatesModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerFindAll(walletId: kotlin.String, order: OrderReceiveControllerFindAll? = null, orderBy: OrderByReceiveControllerFindAll? = null, perPage: kotlin.Any? = null, page: kotlin.Any? = null) : CredentialReceiveStatesModelDto {
        val localVarResponse = receiveControllerFindAllWithHttpInfo(walletId = walletId, order = order, orderBy = orderBy, perPage = perPage, page = page)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CredentialReceiveStatesModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get credential receive states
     * 
     * @param walletId 
     * @param order Issuance state response order. Default ordering: &#x60;DESC&#x60; (Supported: &#x60;ASC&#x60;, &#x60;DESC&#x60;) (optional)
     * @param orderBy Order Issuance state by an attribute, defaults to: &#x60;created_at&#x60; (Supported: &#x60;created_at&#x60;) (optional)
     * @param perPage Number of records per page (optional)
     * @param page Page number (starting from 1) (optional)
     * @return ApiResponse<CredentialReceiveStatesModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerFindAllWithHttpInfo(walletId: kotlin.String, order: OrderReceiveControllerFindAll?, orderBy: OrderByReceiveControllerFindAll?, perPage: kotlin.Any?, page: kotlin.Any?) : ApiResponse<CredentialReceiveStatesModelDto?> {
        val localVariableConfig = receiveControllerFindAllRequestConfig(walletId = walletId, order = order, orderBy = orderBy, perPage = perPage, page = page)

        return request<Unit, CredentialReceiveStatesModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerFindAll
     *
     * @param walletId 
     * @param order Issuance state response order. Default ordering: &#x60;DESC&#x60; (Supported: &#x60;ASC&#x60;, &#x60;DESC&#x60;) (optional)
     * @param orderBy Order Issuance state by an attribute, defaults to: &#x60;created_at&#x60; (Supported: &#x60;created_at&#x60;) (optional)
     * @param perPage Number of records per page (optional)
     * @param page Page number (starting from 1) (optional)
     * @return RequestConfig
     */
    fun receiveControllerFindAllRequestConfig(walletId: kotlin.String, order: OrderReceiveControllerFindAll?, orderBy: OrderByReceiveControllerFindAll?, perPage: kotlin.Any?, page: kotlin.Any?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (order != null) {
                    put("order", listOf(order.value))
                }
                if (orderBy != null) {
                    put("order_by", listOf(orderBy.value))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/{walletId}/receive".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get access token
     * The get access token endpoint ensures the wallet is able to retrieve a valid access token to go to the next step of actually getting the credential(s).  Two flows that are supported are: - Pre-Authorized Code Flow - Authorization Code Flow  ### Authorization Code Flow  Uses the &#x60;authorization_code&#x60; as defined in RFC6749 to issue access tokens.  This is usually a two-step process, that involves authentication on the front channel (through a browser window) to be performed by the client.  In step 1, a call to this endpoint returns the &#x60;authorization_url&#x60;. This URL is what needs to be opened in a browser window and will authenticate the end-user to the service. This includes a redirect_uri responsible for receiving and storing the &#x60;authorization_code&#x60;.  In step 2, the service, exchanges the code for an access token by calling the Token Endpoint.  Note that at this point, the wallet initiated Authorization Code flow is not supported.  ### Pre-Authorized Code Flow  This flow is used when the issuer has already authenticated and authorized the end-user. The issuer provides a Pre-Authorized Code in the credential offer which is used to exchange it for an access token in the Token Endpoint. The Authorization Endpoint is not used in this flow.  For more information, see section 3.5 in OpenID4VCI.  ### Next Step  To continue the issuance process, call:  &#x60;&#x60;&#x60;POST /wallets/{walletId}/receive/get_credential&#x60;&#x60;&#x60; 
     * @param walletId 
     * @param credentialReceiveGetAccessTokenRequestModelDto 
     * @return CredentialReceiveGetAccessTokenResponseModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerGetAccessToken(walletId: kotlin.String, credentialReceiveGetAccessTokenRequestModelDto: CredentialReceiveGetAccessTokenRequestModelDto) : CredentialReceiveGetAccessTokenResponseModelDto {
        val localVarResponse = receiveControllerGetAccessTokenWithHttpInfo(walletId = walletId, credentialReceiveGetAccessTokenRequestModelDto = credentialReceiveGetAccessTokenRequestModelDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CredentialReceiveGetAccessTokenResponseModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get access token
     * The get access token endpoint ensures the wallet is able to retrieve a valid access token to go to the next step of actually getting the credential(s).  Two flows that are supported are: - Pre-Authorized Code Flow - Authorization Code Flow  ### Authorization Code Flow  Uses the &#x60;authorization_code&#x60; as defined in RFC6749 to issue access tokens.  This is usually a two-step process, that involves authentication on the front channel (through a browser window) to be performed by the client.  In step 1, a call to this endpoint returns the &#x60;authorization_url&#x60;. This URL is what needs to be opened in a browser window and will authenticate the end-user to the service. This includes a redirect_uri responsible for receiving and storing the &#x60;authorization_code&#x60;.  In step 2, the service, exchanges the code for an access token by calling the Token Endpoint.  Note that at this point, the wallet initiated Authorization Code flow is not supported.  ### Pre-Authorized Code Flow  This flow is used when the issuer has already authenticated and authorized the end-user. The issuer provides a Pre-Authorized Code in the credential offer which is used to exchange it for an access token in the Token Endpoint. The Authorization Endpoint is not used in this flow.  For more information, see section 3.5 in OpenID4VCI.  ### Next Step  To continue the issuance process, call:  &#x60;&#x60;&#x60;POST /wallets/{walletId}/receive/get_credential&#x60;&#x60;&#x60; 
     * @param walletId 
     * @param credentialReceiveGetAccessTokenRequestModelDto 
     * @return ApiResponse<CredentialReceiveGetAccessTokenResponseModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerGetAccessTokenWithHttpInfo(walletId: kotlin.String, credentialReceiveGetAccessTokenRequestModelDto: CredentialReceiveGetAccessTokenRequestModelDto) : ApiResponse<CredentialReceiveGetAccessTokenResponseModelDto?> {
        val localVariableConfig = receiveControllerGetAccessTokenRequestConfig(walletId = walletId, credentialReceiveGetAccessTokenRequestModelDto = credentialReceiveGetAccessTokenRequestModelDto)

        return request<CredentialReceiveGetAccessTokenRequestModelDto, CredentialReceiveGetAccessTokenResponseModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerGetAccessToken
     *
     * @param walletId 
     * @param credentialReceiveGetAccessTokenRequestModelDto 
     * @return RequestConfig
     */
    fun receiveControllerGetAccessTokenRequestConfig(walletId: kotlin.String, credentialReceiveGetAccessTokenRequestModelDto: CredentialReceiveGetAccessTokenRequestModelDto) : RequestConfig<CredentialReceiveGetAccessTokenRequestModelDto> {
        val localVariableBody = credentialReceiveGetAccessTokenRequestModelDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/receive/get_access_token".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get verifiable credential
     * Get credential from the issuer and perform key binding. A valid access token is required in order to call this endpoint.  See section 7 in OpenID4VCI for more information.  ### Key Binding  Key binding is performed by providing either  - &#x60;kid&#x60;: Public key is presented. Should be used when credential format is &#x60;vc+sd-jwt&#x60;. - &#x60;did&#x60;: DID is presented referencing one of the keys contained in the &#x60;verificationMethod&#x60; section of the DID document. Should be used when credential format is &#x60;jwt_vc_json&#x60;.  Only one of the &#x60;kid&#x60; or &#x60;did&#x60; parameters must be present during the request.  Both methods involve the wallet presenting key proof to the issuer to ensure control over cryptographic key material.  See section 7.2.1 in OpenID4VCI for more information.  ### Requesting Multiple Credentials in Sequence  The &#x60;c_nonce&#x60; and &#x60;c_nonce_expires_in&#x60; returned by the issuer allow requesting the same credential, but binding it to different key material. The service automatically manages these attributes, ensuring the correct &#x60;c_nonce&#x60; is used, allowing multiple credentials to be retrieved, but with different keys.  ### Not Supported Options  Note that the following are not supported by the endpoint  - &#x60;transaction_id&#x60;: Part of the deferred issuance flow, allows receiving a credential by referencing a &#x60;transaction_id&#x60; - Receiving encrypted credentials 
     * @param walletId 
     * @param credentialReceiveGetCredentialRequestModelDto 
     * @return CredentialReceiveGetCredentialResponseModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerGetCredential(walletId: kotlin.String, credentialReceiveGetCredentialRequestModelDto: CredentialReceiveGetCredentialRequestModelDto) : CredentialReceiveGetCredentialResponseModelDto {
        val localVarResponse = receiveControllerGetCredentialWithHttpInfo(walletId = walletId, credentialReceiveGetCredentialRequestModelDto = credentialReceiveGetCredentialRequestModelDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CredentialReceiveGetCredentialResponseModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get verifiable credential
     * Get credential from the issuer and perform key binding. A valid access token is required in order to call this endpoint.  See section 7 in OpenID4VCI for more information.  ### Key Binding  Key binding is performed by providing either  - &#x60;kid&#x60;: Public key is presented. Should be used when credential format is &#x60;vc+sd-jwt&#x60;. - &#x60;did&#x60;: DID is presented referencing one of the keys contained in the &#x60;verificationMethod&#x60; section of the DID document. Should be used when credential format is &#x60;jwt_vc_json&#x60;.  Only one of the &#x60;kid&#x60; or &#x60;did&#x60; parameters must be present during the request.  Both methods involve the wallet presenting key proof to the issuer to ensure control over cryptographic key material.  See section 7.2.1 in OpenID4VCI for more information.  ### Requesting Multiple Credentials in Sequence  The &#x60;c_nonce&#x60; and &#x60;c_nonce_expires_in&#x60; returned by the issuer allow requesting the same credential, but binding it to different key material. The service automatically manages these attributes, ensuring the correct &#x60;c_nonce&#x60; is used, allowing multiple credentials to be retrieved, but with different keys.  ### Not Supported Options  Note that the following are not supported by the endpoint  - &#x60;transaction_id&#x60;: Part of the deferred issuance flow, allows receiving a credential by referencing a &#x60;transaction_id&#x60; - Receiving encrypted credentials 
     * @param walletId 
     * @param credentialReceiveGetCredentialRequestModelDto 
     * @return ApiResponse<CredentialReceiveGetCredentialResponseModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerGetCredentialWithHttpInfo(walletId: kotlin.String, credentialReceiveGetCredentialRequestModelDto: CredentialReceiveGetCredentialRequestModelDto) : ApiResponse<CredentialReceiveGetCredentialResponseModelDto?> {
        val localVariableConfig = receiveControllerGetCredentialRequestConfig(walletId = walletId, credentialReceiveGetCredentialRequestModelDto = credentialReceiveGetCredentialRequestModelDto)

        return request<CredentialReceiveGetCredentialRequestModelDto, CredentialReceiveGetCredentialResponseModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerGetCredential
     *
     * @param walletId 
     * @param credentialReceiveGetCredentialRequestModelDto 
     * @return RequestConfig
     */
    fun receiveControllerGetCredentialRequestConfig(walletId: kotlin.String, credentialReceiveGetCredentialRequestModelDto: CredentialReceiveGetCredentialRequestModelDto) : RequestConfig<CredentialReceiveGetCredentialRequestModelDto> {
        val localVariableBody = credentialReceiveGetCredentialRequestModelDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/receive/get_credential".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get credential receive state
     * 
     * @param walletId 
     * @param state 
     * @return CredentialReceiveStateModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun receiveControllerGetInfo(walletId: kotlin.String, state: kotlin.String) : CredentialReceiveStateModelDto {
        val localVarResponse = receiveControllerGetInfoWithHttpInfo(walletId = walletId, state = state)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CredentialReceiveStateModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get credential receive state
     * 
     * @param walletId 
     * @param state 
     * @return ApiResponse<CredentialReceiveStateModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun receiveControllerGetInfoWithHttpInfo(walletId: kotlin.String, state: kotlin.String) : ApiResponse<CredentialReceiveStateModelDto?> {
        val localVariableConfig = receiveControllerGetInfoRequestConfig(walletId = walletId, state = state)

        return request<Unit, CredentialReceiveStateModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation receiveControllerGetInfo
     *
     * @param walletId 
     * @param state 
     * @return RequestConfig
     */
    fun receiveControllerGetInfoRequestConfig(walletId: kotlin.String, state: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/{walletId}/receive/{state}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"state"+"}", encodeURIComponent(state.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
