/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package me.meeco.holder.wallet.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import me.meeco.holder.wallet.models.InternalServerError
import me.meeco.holder.wallet.models.InvalidDateFilterValueError
import me.meeco.holder.wallet.models.WalletCountsResponseDto

import com.squareup.moshi.Json

import me.meeco.holder.wallet.infrastructure.ApiClient
import me.meeco.holder.wallet.infrastructure.ApiResponse
import me.meeco.holder.wallet.infrastructure.ClientException
import me.meeco.holder.wallet.infrastructure.ClientError
import me.meeco.holder.wallet.infrastructure.ServerException
import me.meeco.holder.wallet.infrastructure.ServerError
import me.meeco.holder.wallet.infrastructure.MultiValueMap
import me.meeco.holder.wallet.infrastructure.PartConfig
import me.meeco.holder.wallet.infrastructure.RequestConfig
import me.meeco.holder.wallet.infrastructure.RequestMethod
import me.meeco.holder.wallet.infrastructure.ResponseType
import me.meeco.holder.wallet.infrastructure.Success
import me.meeco.holder.wallet.infrastructure.toMultiValue

class SystemMetricsApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://holder-wallet-dev.svx.internal")
        }
    }

    /**
     * Wallet metrics
     * 
     * @param startDate Counts only wallets created after the given date (optional)
     * @param endDate Counts only wallets created before the given date (optional)
     * @return WalletCountsResponseDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun systemMetricsControllerGetWalletCounts(startDate: kotlin.String? = null, endDate: kotlin.String? = null) : WalletCountsResponseDto {
        val localVarResponse = systemMetricsControllerGetWalletCountsWithHttpInfo(startDate = startDate, endDate = endDate)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as WalletCountsResponseDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Wallet metrics
     * 
     * @param startDate Counts only wallets created after the given date (optional)
     * @param endDate Counts only wallets created before the given date (optional)
     * @return ApiResponse<WalletCountsResponseDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun systemMetricsControllerGetWalletCountsWithHttpInfo(startDate: kotlin.String?, endDate: kotlin.String?) : ApiResponse<WalletCountsResponseDto?> {
        val localVariableConfig = systemMetricsControllerGetWalletCountsRequestConfig(startDate = startDate, endDate = endDate)

        return request<Unit, WalletCountsResponseDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation systemMetricsControllerGetWalletCounts
     *
     * @param startDate Counts only wallets created after the given date (optional)
     * @param endDate Counts only wallets created before the given date (optional)
     * @return RequestConfig
     */
    fun systemMetricsControllerGetWalletCountsRequestConfig(startDate: kotlin.String?, endDate: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (startDate != null) {
                    put("start_date", listOf(startDate.toString()))
                }
                if (endDate != null) {
                    put("end_date", listOf(endDate.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/system/metrics/wallets",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
