/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package me.meeco.holder.wallet.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import me.meeco.holder.wallet.models.InvalidPathParamError
import me.meeco.holder.wallet.models.InvalidRequestPayloadError
import me.meeco.holder.wallet.models.KeyControllerImport400Response
import me.meeco.holder.wallet.models.KeyControllerImportRequest
import me.meeco.holder.wallet.models.KeyControllerSign201Response
import me.meeco.holder.wallet.models.KeyControllerSign400Response
import me.meeco.holder.wallet.models.KeyControllerSignRequest
import me.meeco.holder.wallet.models.KeysControllerCreate201Response
import me.meeco.holder.wallet.models.KeysControllerCreateRequest
import me.meeco.holder.wallet.models.KeysControllerGet404Response
import me.meeco.holder.wallet.models.WalletNotFoundError

import com.squareup.moshi.Json

import me.meeco.holder.wallet.infrastructure.ApiClient
import me.meeco.holder.wallet.infrastructure.ApiResponse
import me.meeco.holder.wallet.infrastructure.ClientException
import me.meeco.holder.wallet.infrastructure.ClientError
import me.meeco.holder.wallet.infrastructure.ServerException
import me.meeco.holder.wallet.infrastructure.ServerError
import me.meeco.holder.wallet.infrastructure.MultiValueMap
import me.meeco.holder.wallet.infrastructure.PartConfig
import me.meeco.holder.wallet.infrastructure.RequestConfig
import me.meeco.holder.wallet.infrastructure.RequestMethod
import me.meeco.holder.wallet.infrastructure.ResponseType
import me.meeco.holder.wallet.infrastructure.Success
import me.meeco.holder.wallet.infrastructure.toMultiValue

class KeyManagementApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://holder-wallet-dev.svx.internal")
        }
    }

    /**
     * Import a key to a Wallet
     * Import an existing cryptographic key to a Wallet using the JOSE JWK notation.  Depending on the configuration of the service only certain cryptographic keys are supported. 
     * @param walletId 
     * @param keyControllerImportRequest 
     * @return KeysControllerCreate201Response
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun keyControllerImport(walletId: kotlin.String, keyControllerImportRequest: KeyControllerImportRequest) : KeysControllerCreate201Response {
        val localVarResponse = keyControllerImportWithHttpInfo(walletId = walletId, keyControllerImportRequest = keyControllerImportRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as KeysControllerCreate201Response
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Import a key to a Wallet
     * Import an existing cryptographic key to a Wallet using the JOSE JWK notation.  Depending on the configuration of the service only certain cryptographic keys are supported. 
     * @param walletId 
     * @param keyControllerImportRequest 
     * @return ApiResponse<KeysControllerCreate201Response?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun keyControllerImportWithHttpInfo(walletId: kotlin.String, keyControllerImportRequest: KeyControllerImportRequest) : ApiResponse<KeysControllerCreate201Response?> {
        val localVariableConfig = keyControllerImportRequestConfig(walletId = walletId, keyControllerImportRequest = keyControllerImportRequest)

        return request<KeyControllerImportRequest, KeysControllerCreate201Response>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation keyControllerImport
     *
     * @param walletId 
     * @param keyControllerImportRequest 
     * @return RequestConfig
     */
    fun keyControllerImportRequestConfig(walletId: kotlin.String, keyControllerImportRequest: KeyControllerImportRequest) : RequestConfig<KeyControllerImportRequest> {
        val localVariableBody = keyControllerImportRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/keys/import".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Sign data with a key from a wallet
     * Create a signature based on data provided using a cryptographic key associated with a Wallet. 
     * @param walletId 
     * @param keyId 
     * @param keyControllerSignRequest 
     * @return KeyControllerSign201Response
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun keyControllerSign(walletId: kotlin.String, keyId: kotlin.String, keyControllerSignRequest: KeyControllerSignRequest) : KeyControllerSign201Response {
        val localVarResponse = keyControllerSignWithHttpInfo(walletId = walletId, keyId = keyId, keyControllerSignRequest = keyControllerSignRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as KeyControllerSign201Response
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Sign data with a key from a wallet
     * Create a signature based on data provided using a cryptographic key associated with a Wallet. 
     * @param walletId 
     * @param keyId 
     * @param keyControllerSignRequest 
     * @return ApiResponse<KeyControllerSign201Response?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun keyControllerSignWithHttpInfo(walletId: kotlin.String, keyId: kotlin.String, keyControllerSignRequest: KeyControllerSignRequest) : ApiResponse<KeyControllerSign201Response?> {
        val localVariableConfig = keyControllerSignRequestConfig(walletId = walletId, keyId = keyId, keyControllerSignRequest = keyControllerSignRequest)

        return request<KeyControllerSignRequest, KeyControllerSign201Response>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation keyControllerSign
     *
     * @param walletId 
     * @param keyId 
     * @param keyControllerSignRequest 
     * @return RequestConfig
     */
    fun keyControllerSignRequestConfig(walletId: kotlin.String, keyId: kotlin.String, keyControllerSignRequest: KeyControllerSignRequest) : RequestConfig<KeyControllerSignRequest> {
        val localVariableBody = keyControllerSignRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/keys/{keyId}/sign".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"keyId"+"}", encodeURIComponent(keyId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Create a key for a Wallet
     * Create a new cryptographic key associated with the Wallet. Keys are created using the JOSE JWK standard using attribute strings listed in the [JOSE IANA registry](https://www.iana.org/assignments/jose/jose.xhtml).  Depending on the configuration of the service only certain cryptographic keys are supported. 
     * @param walletId 
     * @param keysControllerCreateRequest 
     * @return KeysControllerCreate201Response
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun keysControllerCreate(walletId: kotlin.String, keysControllerCreateRequest: KeysControllerCreateRequest) : KeysControllerCreate201Response {
        val localVarResponse = keysControllerCreateWithHttpInfo(walletId = walletId, keysControllerCreateRequest = keysControllerCreateRequest)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as KeysControllerCreate201Response
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Create a key for a Wallet
     * Create a new cryptographic key associated with the Wallet. Keys are created using the JOSE JWK standard using attribute strings listed in the [JOSE IANA registry](https://www.iana.org/assignments/jose/jose.xhtml).  Depending on the configuration of the service only certain cryptographic keys are supported. 
     * @param walletId 
     * @param keysControllerCreateRequest 
     * @return ApiResponse<KeysControllerCreate201Response?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun keysControllerCreateWithHttpInfo(walletId: kotlin.String, keysControllerCreateRequest: KeysControllerCreateRequest) : ApiResponse<KeysControllerCreate201Response?> {
        val localVariableConfig = keysControllerCreateRequestConfig(walletId = walletId, keysControllerCreateRequest = keysControllerCreateRequest)

        return request<KeysControllerCreateRequest, KeysControllerCreate201Response>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation keysControllerCreate
     *
     * @param walletId 
     * @param keysControllerCreateRequest 
     * @return RequestConfig
     */
    fun keysControllerCreateRequestConfig(walletId: kotlin.String, keysControllerCreateRequest: KeysControllerCreateRequest) : RequestConfig<KeysControllerCreateRequest> {
        val localVariableBody = keysControllerCreateRequest
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/keys".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete a key from a Wallet
     * 
     * @param walletId 
     * @param keyId 
     * @return void
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun keysControllerDelete(walletId: kotlin.String, keyId: kotlin.String) : Unit {
        val localVarResponse = keysControllerDeleteWithHttpInfo(walletId = walletId, keyId = keyId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete a key from a Wallet
     * 
     * @param walletId 
     * @param keyId 
     * @return ApiResponse<Unit?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Throws(IllegalStateException::class, IOException::class)
    fun keysControllerDeleteWithHttpInfo(walletId: kotlin.String, keyId: kotlin.String) : ApiResponse<Unit?> {
        val localVariableConfig = keysControllerDeleteRequestConfig(walletId = walletId, keyId = keyId)

        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation keysControllerDelete
     *
     * @param walletId 
     * @param keyId 
     * @return RequestConfig
     */
    fun keysControllerDeleteRequestConfig(walletId: kotlin.String, keyId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/wallets/{walletId}/keys/{keyId}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"keyId"+"}", encodeURIComponent(keyId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get a key for a Wallet
     * Return the cryptographic key information for a key associated with a Wallet.  The information returned contains only header and public attributes of the key, i.e. not the private key information which is kept in the Wallet. Key information is returned in the JOSE JWK standard using attribute strings listed in the [JOSE IANA registry](https://www.iana.org/assignments/jose/jose.xhtml). 
     * @param walletId 
     * @param keyId 
     * @return KeysControllerCreate201Response
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun keysControllerGet(walletId: kotlin.String, keyId: kotlin.String) : KeysControllerCreate201Response {
        val localVarResponse = keysControllerGetWithHttpInfo(walletId = walletId, keyId = keyId)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as KeysControllerCreate201Response
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get a key for a Wallet
     * Return the cryptographic key information for a key associated with a Wallet.  The information returned contains only header and public attributes of the key, i.e. not the private key information which is kept in the Wallet. Key information is returned in the JOSE JWK standard using attribute strings listed in the [JOSE IANA registry](https://www.iana.org/assignments/jose/jose.xhtml). 
     * @param walletId 
     * @param keyId 
     * @return ApiResponse<KeysControllerCreate201Response?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun keysControllerGetWithHttpInfo(walletId: kotlin.String, keyId: kotlin.String) : ApiResponse<KeysControllerCreate201Response?> {
        val localVariableConfig = keysControllerGetRequestConfig(walletId = walletId, keyId = keyId)

        return request<Unit, KeysControllerCreate201Response>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation keysControllerGet
     *
     * @param walletId 
     * @param keyId 
     * @return RequestConfig
     */
    fun keysControllerGetRequestConfig(walletId: kotlin.String, keyId: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/{walletId}/keys/{keyId}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"keyId"+"}", encodeURIComponent(keyId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
