/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package me.meeco.holder.wallet.apis

import java.io.IOException
import okhttp3.OkHttpClient
import okhttp3.HttpUrl

import me.meeco.holder.wallet.models.AuthorizationRequestResponseDto
import me.meeco.holder.wallet.models.InvalidClaimsToDiscloseError
import me.meeco.holder.wallet.models.InvalidPathParamError
import me.meeco.holder.wallet.models.PresentationControllerCreate400Response
import me.meeco.holder.wallet.models.PresentationRequestSendRequestModelDto
import me.meeco.holder.wallet.models.PresentationRequestSetCredentialsRequestModelDto
import me.meeco.holder.wallet.models.PresentationRequestSetCredentialsResponseModelDto
import me.meeco.holder.wallet.models.PresentationRequestSubmitRequestModelDto
import me.meeco.holder.wallet.models.PresentationRequestSubmitResponseModelDto
import me.meeco.holder.wallet.models.PresentationStateResponseDto
import me.meeco.holder.wallet.models.PresentationStatesResponseDto
import me.meeco.holder.wallet.models.ReceiveControllerFindAll400Response
import me.meeco.holder.wallet.models.ReceiveControllerFindAll500Response
import me.meeco.holder.wallet.models.SendControllerDeleteOne404Response
import me.meeco.holder.wallet.models.SendControllerDeleteOne500Response
import me.meeco.holder.wallet.models.WalletNotFoundError

import com.squareup.moshi.Json

import me.meeco.holder.wallet.infrastructure.ApiClient
import me.meeco.holder.wallet.infrastructure.ApiResponse
import me.meeco.holder.wallet.infrastructure.ClientException
import me.meeco.holder.wallet.infrastructure.ClientError
import me.meeco.holder.wallet.infrastructure.ServerException
import me.meeco.holder.wallet.infrastructure.ServerError
import me.meeco.holder.wallet.infrastructure.MultiValueMap
import me.meeco.holder.wallet.infrastructure.PartConfig
import me.meeco.holder.wallet.infrastructure.RequestConfig
import me.meeco.holder.wallet.infrastructure.RequestMethod
import me.meeco.holder.wallet.infrastructure.ResponseType
import me.meeco.holder.wallet.infrastructure.Success
import me.meeco.holder.wallet.infrastructure.toMultiValue

class VerifiablePresentationApi(basePath: kotlin.String = defaultBasePath, client: OkHttpClient = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "https://holder-wallet-dev.svx.internal")
        }
    }

    /**
     * Register authorization request
     * Parse the authorization request URI and get the following information.  - &#x60;client_id&#x60;: The Client ID of the verifier. - &#x60;client_id_scheme&#x60;: The Client ID scheme of the verifier. - &#x60;client_metadata&#x60;: Verifier client metadata. - &#x60;nonce&#x60;: Nonce provided by the verifier to be returned in the response - &#x60;presentation_definition&#x60;: What credentials the verifier is requesting from the Wallet. - &#x60;redirect_uri&#x60;: The redirect URI of the verifier. - &#x60;response_mode&#x60;: How to return the response. - &#x60;response_type&#x60;: Which parameters to use to return the presentation to the verifier. - &#x60;response_uri&#x60;: Where to send the response. - &#x60;verifier_state&#x60;: State passed by the verifier to link request and response. - &#x60;meta.protocol_version&#x60;: Version of the protocol to be used. Supported values &#x60;draft10&#x60; and &#x60;draft18&#x60;. The default value is &#x60;draft10&#x60;.  This information informs the Wallet how to process the request and respond to the verifier.  ## Request Parameters  The following sections describe in more detail the parameters, their default values and behaviour.  ### client_id (required)  Depending on the &#x60;client_id_scheme&#x60; the Client ID is either the &#x60;client_id&#x60;, the &#x60;redirect_uri&#x60; or the &#x60;did&#x60; of the verifier.  ### client_id_scheme  The mechanism to obtain and validate metadata of a verifier beyond that specified in RFC6749.  Currently supported values are: - &#x60;pre-registered&#x60; (default): The verifier is pre-registered with the SVX Platform. - &#x60;redirect_uri&#x60;: The redirect URI is the identifier of the verifier. Note that in this case the request MUST NOT be signed. - &#x60;did&#x60;: The DID is the identifier of the verifier. Note that in this case the request MUST be signed with a &#x60;verificationMethod&#x60; property in the DID document. This also requires that verifier metadata is passed using &#x60;client_metadata&#x60; or &#x60;client_metadata_uri&#x60;.  ### client_metadata (required)  Client metadata, also called verifier metadata in this case can be implemented using static configuration values, as well as employ Dynamic Discovery.  The static configuration is usually bound to an existing profile, for example.  - [JWT VC Presentation Profile](https://identity.foundation/jwt-vc-presentation-profile/) - [HAIP](https://openid.net/specs/openid4vc-high-assurance-interoperability-profile-sd-jwt-vc-1_0-00.html)  They use specific, custom URL schemes such as &#x60;openid-vc&#x60; or &#x60;haip&#x60;. When these are used, values referred to in these profiles should be used as client metadata.  Each network can define their own set of static configuration values for client metadata.  The use of fedarations or trust schemes is not yet supported.  ### nonce  Nonce to be returned in the response to prevent replay attacks.  ### presentation_definition (required)  Expresses which credentials a verifier asks a wallet to present. The syntax to do this should conform to DIF Presentation Exchange specification. The structure of the definition is validated by a JSON schema associated with the &#x60;presentation_definition&#x60; schema in the OpenAPI definition.  It is also possible to use &#x60;presentation_definition_uri&#x60;. In this case the wallet performs a GET request to the &#x60;presentation_definition_uri&#x60; and parses the response. The response is stored in the &#x60;presentation_definition&#x60; attribute.  Note that the service does not necessarily support all options defined in the Presentation Exchange specification.  ### response_mode  How the response is sent to the verifier. Possible values are  - &#x60;direct_post&#x60;: In this mode, the Authorization Response is sent to the Verifier using an HTTPS POST request to an endpoint controlled by the Verifier. The Authorization Response parameters are encoded in the body using the application/x-www-form-urlencoded content type.  When using &#x60;direct_post&#x60;, note that the &#x60;redirect_uri&#x60; must be returned after successfully posting the Authorization Response to the &#x60;response_uri&#x60;.  Note that &#x60;fragment&#x60; is currently not supported.  ### response_uri  If the &#x60;response_mode&#x60; is &#x60;direct_post&#x60; this is the URI to send the response to.  ### verifier_state  Opaque state that can be used to link the request and response. Is returned as the &#x60;state&#x60; parameter in the Authorization Response.  ## Use of JAR (RFC9101)  JAR (RFC9101) is a JWT representation of the request. The JWT is signed with the verifier&#39;s private key. There are two ways to do this.  - &#x60;request&#x60;: The &#x60;request&#x60; parameter is the JWT representation of the request. - &#x60;request_uri&#x60;: The &#x60;request_uri&#x60; parameter is the URL of the request.  In most cases &#x60;request_uri&#x60; is used instead of &#x60;request&#x60; as it is more convenient, especially in situations when a QR code is used to represent the authorization request.  The JAR contains the necessary information and is fetched, verified and subsequently parsed. See the previous section for more details.  ## Examples  Below are some examples of valid authorization requests and how they are parsed.  &#x60;&#x60;&#x60; openid-vc://?request_uri&#x3D;https://example.com/oidc/presentations/requests/c63aa3e9-dc7d-4753-9ac8-30bf7add6e4c/jwt&amp;client_id&#x3D;https://example.com/cb &#x60;&#x60;&#x60;  This is an example where JAR is used. First, the &#x60;request_uri&#x60; is used to fetch the request JWT. The JWT is validated and then parsed. The parsed request is stored in the &#x60;metadata.request&#x60; attribute. All the required information, except for the &#x60;client_id&#x60; is fetched from the JWT, validated and stored. 
     * @param walletId 
     * @param presentationRequestSendRequestModelDto 
     * @return AuthorizationRequestResponseDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun presentationControllerCreate(walletId: kotlin.String, presentationRequestSendRequestModelDto: PresentationRequestSendRequestModelDto) : AuthorizationRequestResponseDto {
        val localVarResponse = presentationControllerCreateWithHttpInfo(walletId = walletId, presentationRequestSendRequestModelDto = presentationRequestSendRequestModelDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as AuthorizationRequestResponseDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Register authorization request
     * Parse the authorization request URI and get the following information.  - &#x60;client_id&#x60;: The Client ID of the verifier. - &#x60;client_id_scheme&#x60;: The Client ID scheme of the verifier. - &#x60;client_metadata&#x60;: Verifier client metadata. - &#x60;nonce&#x60;: Nonce provided by the verifier to be returned in the response - &#x60;presentation_definition&#x60;: What credentials the verifier is requesting from the Wallet. - &#x60;redirect_uri&#x60;: The redirect URI of the verifier. - &#x60;response_mode&#x60;: How to return the response. - &#x60;response_type&#x60;: Which parameters to use to return the presentation to the verifier. - &#x60;response_uri&#x60;: Where to send the response. - &#x60;verifier_state&#x60;: State passed by the verifier to link request and response. - &#x60;meta.protocol_version&#x60;: Version of the protocol to be used. Supported values &#x60;draft10&#x60; and &#x60;draft18&#x60;. The default value is &#x60;draft10&#x60;.  This information informs the Wallet how to process the request and respond to the verifier.  ## Request Parameters  The following sections describe in more detail the parameters, their default values and behaviour.  ### client_id (required)  Depending on the &#x60;client_id_scheme&#x60; the Client ID is either the &#x60;client_id&#x60;, the &#x60;redirect_uri&#x60; or the &#x60;did&#x60; of the verifier.  ### client_id_scheme  The mechanism to obtain and validate metadata of a verifier beyond that specified in RFC6749.  Currently supported values are: - &#x60;pre-registered&#x60; (default): The verifier is pre-registered with the SVX Platform. - &#x60;redirect_uri&#x60;: The redirect URI is the identifier of the verifier. Note that in this case the request MUST NOT be signed. - &#x60;did&#x60;: The DID is the identifier of the verifier. Note that in this case the request MUST be signed with a &#x60;verificationMethod&#x60; property in the DID document. This also requires that verifier metadata is passed using &#x60;client_metadata&#x60; or &#x60;client_metadata_uri&#x60;.  ### client_metadata (required)  Client metadata, also called verifier metadata in this case can be implemented using static configuration values, as well as employ Dynamic Discovery.  The static configuration is usually bound to an existing profile, for example.  - [JWT VC Presentation Profile](https://identity.foundation/jwt-vc-presentation-profile/) - [HAIP](https://openid.net/specs/openid4vc-high-assurance-interoperability-profile-sd-jwt-vc-1_0-00.html)  They use specific, custom URL schemes such as &#x60;openid-vc&#x60; or &#x60;haip&#x60;. When these are used, values referred to in these profiles should be used as client metadata.  Each network can define their own set of static configuration values for client metadata.  The use of fedarations or trust schemes is not yet supported.  ### nonce  Nonce to be returned in the response to prevent replay attacks.  ### presentation_definition (required)  Expresses which credentials a verifier asks a wallet to present. The syntax to do this should conform to DIF Presentation Exchange specification. The structure of the definition is validated by a JSON schema associated with the &#x60;presentation_definition&#x60; schema in the OpenAPI definition.  It is also possible to use &#x60;presentation_definition_uri&#x60;. In this case the wallet performs a GET request to the &#x60;presentation_definition_uri&#x60; and parses the response. The response is stored in the &#x60;presentation_definition&#x60; attribute.  Note that the service does not necessarily support all options defined in the Presentation Exchange specification.  ### response_mode  How the response is sent to the verifier. Possible values are  - &#x60;direct_post&#x60;: In this mode, the Authorization Response is sent to the Verifier using an HTTPS POST request to an endpoint controlled by the Verifier. The Authorization Response parameters are encoded in the body using the application/x-www-form-urlencoded content type.  When using &#x60;direct_post&#x60;, note that the &#x60;redirect_uri&#x60; must be returned after successfully posting the Authorization Response to the &#x60;response_uri&#x60;.  Note that &#x60;fragment&#x60; is currently not supported.  ### response_uri  If the &#x60;response_mode&#x60; is &#x60;direct_post&#x60; this is the URI to send the response to.  ### verifier_state  Opaque state that can be used to link the request and response. Is returned as the &#x60;state&#x60; parameter in the Authorization Response.  ## Use of JAR (RFC9101)  JAR (RFC9101) is a JWT representation of the request. The JWT is signed with the verifier&#39;s private key. There are two ways to do this.  - &#x60;request&#x60;: The &#x60;request&#x60; parameter is the JWT representation of the request. - &#x60;request_uri&#x60;: The &#x60;request_uri&#x60; parameter is the URL of the request.  In most cases &#x60;request_uri&#x60; is used instead of &#x60;request&#x60; as it is more convenient, especially in situations when a QR code is used to represent the authorization request.  The JAR contains the necessary information and is fetched, verified and subsequently parsed. See the previous section for more details.  ## Examples  Below are some examples of valid authorization requests and how they are parsed.  &#x60;&#x60;&#x60; openid-vc://?request_uri&#x3D;https://example.com/oidc/presentations/requests/c63aa3e9-dc7d-4753-9ac8-30bf7add6e4c/jwt&amp;client_id&#x3D;https://example.com/cb &#x60;&#x60;&#x60;  This is an example where JAR is used. First, the &#x60;request_uri&#x60; is used to fetch the request JWT. The JWT is validated and then parsed. The parsed request is stored in the &#x60;metadata.request&#x60; attribute. All the required information, except for the &#x60;client_id&#x60; is fetched from the JWT, validated and stored. 
     * @param walletId 
     * @param presentationRequestSendRequestModelDto 
     * @return ApiResponse<AuthorizationRequestResponseDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun presentationControllerCreateWithHttpInfo(walletId: kotlin.String, presentationRequestSendRequestModelDto: PresentationRequestSendRequestModelDto) : ApiResponse<AuthorizationRequestResponseDto?> {
        val localVariableConfig = presentationControllerCreateRequestConfig(walletId = walletId, presentationRequestSendRequestModelDto = presentationRequestSendRequestModelDto)

        return request<PresentationRequestSendRequestModelDto, AuthorizationRequestResponseDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation presentationControllerCreate
     *
     * @param walletId 
     * @param presentationRequestSendRequestModelDto 
     * @return RequestConfig
     */
    fun presentationControllerCreateRequestConfig(walletId: kotlin.String, presentationRequestSendRequestModelDto: PresentationRequestSendRequestModelDto) : RequestConfig<PresentationRequestSendRequestModelDto> {
        val localVariableBody = presentationRequestSendRequestModelDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/send".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * enum for parameter order
     */
     enum class OrderPresentationControllerFindAll(val value: kotlin.String) {
         @Json(name = "ASC") aSC("ASC"),
         @Json(name = "DESC") dESC("DESC")
     }

    /**
     * enum for parameter orderBy
     */
     enum class OrderByPresentationControllerFindAll(val value: kotlin.String) {
         @Json(name = "created_at") createdAt("created_at")
     }

    /**
     * Get presentation states
     * 
     * @param walletId 
     * @param order Presentation States response order. Default ordering: &#x60;DESC&#x60; (Supported: &#x60;ASC&#x60;, &#x60;DESC&#x60;) (optional)
     * @param orderBy Order Presentation States by an attribute, defaults to: &#x60;created_at&#x60; (Supported: &#x60;created_at&#x60;) (optional)
     * @param perPage Number of records per page (optional)
     * @param page Page number (starting from 1) (optional)
     * @return PresentationStatesResponseDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun presentationControllerFindAll(walletId: kotlin.String, order: OrderPresentationControllerFindAll? = null, orderBy: OrderByPresentationControllerFindAll? = null, perPage: kotlin.Any? = null, page: kotlin.Any? = null) : PresentationStatesResponseDto {
        val localVarResponse = presentationControllerFindAllWithHttpInfo(walletId = walletId, order = order, orderBy = orderBy, perPage = perPage, page = page)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PresentationStatesResponseDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get presentation states
     * 
     * @param walletId 
     * @param order Presentation States response order. Default ordering: &#x60;DESC&#x60; (Supported: &#x60;ASC&#x60;, &#x60;DESC&#x60;) (optional)
     * @param orderBy Order Presentation States by an attribute, defaults to: &#x60;created_at&#x60; (Supported: &#x60;created_at&#x60;) (optional)
     * @param perPage Number of records per page (optional)
     * @param page Page number (starting from 1) (optional)
     * @return ApiResponse<PresentationStatesResponseDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun presentationControllerFindAllWithHttpInfo(walletId: kotlin.String, order: OrderPresentationControllerFindAll?, orderBy: OrderByPresentationControllerFindAll?, perPage: kotlin.Any?, page: kotlin.Any?) : ApiResponse<PresentationStatesResponseDto?> {
        val localVariableConfig = presentationControllerFindAllRequestConfig(walletId = walletId, order = order, orderBy = orderBy, perPage = perPage, page = page)

        return request<Unit, PresentationStatesResponseDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation presentationControllerFindAll
     *
     * @param walletId 
     * @param order Presentation States response order. Default ordering: &#x60;DESC&#x60; (Supported: &#x60;ASC&#x60;, &#x60;DESC&#x60;) (optional)
     * @param orderBy Order Presentation States by an attribute, defaults to: &#x60;created_at&#x60; (Supported: &#x60;created_at&#x60;) (optional)
     * @param perPage Number of records per page (optional)
     * @param page Page number (starting from 1) (optional)
     * @return RequestConfig
     */
    fun presentationControllerFindAllRequestConfig(walletId: kotlin.String, order: OrderPresentationControllerFindAll?, orderBy: OrderByPresentationControllerFindAll?, perPage: kotlin.Any?, page: kotlin.Any?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (order != null) {
                    put("order", listOf(order.value))
                }
                if (orderBy != null) {
                    put("order_by", listOf(orderBy.value))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/{walletId}/send".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Delete Verifiable Presentation State by ID
     * Delete state of a presentation flow
     * @param walletId 
     * @param state 
     * @return void
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendControllerDeleteOne(walletId: kotlin.String, state: kotlin.String) : Unit {
        val localVarResponse = sendControllerDeleteOneWithHttpInfo(walletId = walletId, state = state)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Delete Verifiable Presentation State by ID
     * Delete state of a presentation flow
     * @param walletId 
     * @param state 
     * @return ApiResponse<Unit?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Throws(IllegalStateException::class, IOException::class)
    fun sendControllerDeleteOneWithHttpInfo(walletId: kotlin.String, state: kotlin.String) : ApiResponse<Unit?> {
        val localVariableConfig = sendControllerDeleteOneRequestConfig(walletId = walletId, state = state)

        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation sendControllerDeleteOne
     *
     * @param walletId 
     * @param state 
     * @return RequestConfig
     */
    fun sendControllerDeleteOneRequestConfig(walletId: kotlin.String, state: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/wallets/{walletId}/send/{state}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"state"+"}", encodeURIComponent(state.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Get present credential state
     * 
     * @param walletId 
     * @param state 
     * @return PresentationStateResponseDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendControllerFindOne(walletId: kotlin.String, state: kotlin.String) : PresentationStateResponseDto {
        val localVarResponse = sendControllerFindOneWithHttpInfo(walletId = walletId, state = state)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PresentationStateResponseDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Get present credential state
     * 
     * @param walletId 
     * @param state 
     * @return ApiResponse<PresentationStateResponseDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun sendControllerFindOneWithHttpInfo(walletId: kotlin.String, state: kotlin.String) : ApiResponse<PresentationStateResponseDto?> {
        val localVariableConfig = sendControllerFindOneRequestConfig(walletId = walletId, state = state)

        return request<Unit, PresentationStateResponseDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation sendControllerFindOne
     *
     * @param walletId 
     * @param state 
     * @return RequestConfig
     */
    fun sendControllerFindOneRequestConfig(walletId: kotlin.String, state: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/wallets/{walletId}/send/{state}".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())).replace("{"+"state"+"}", encodeURIComponent(state.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Set the credentials to be presented
     * Set the credentials to be presented as part of this presentation response.  Each credential must be linked to an input descriptor from the credential definition. For credentials that support selective disclosure, there is the possibility to use the &#x60;claims_to_disclose&#x60; property. Use object notation to specify which claims to disclose. For example:  &#x60;&#x60;&#x60; \&quot;claims_to_disclose\&quot;: [\&quot;given_name\&quot;, \&quot;address.street_address\&quot;, \&quot;address.locality\&quot;, \&quot;nationalities[0]\&quot;] &#x60;&#x60;&#x60;  If a claim or a nested claim is not found in the credential or it doesn&#39;t support selective disclosure, it will be ignored.  By default, the key ID linked to the credential is used to sign the presentation. The &#x60;kid&#x60; property can be used to specify another key ID. If no key ID is linked to the credential and none is specified, no signature is added to the presentation. 
     * @param walletId 
     * @param presentationRequestSetCredentialsRequestModelDto 
     * @return PresentationRequestSetCredentialsResponseModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendControllerSetCredentials(walletId: kotlin.String, presentationRequestSetCredentialsRequestModelDto: PresentationRequestSetCredentialsRequestModelDto) : PresentationRequestSetCredentialsResponseModelDto {
        val localVarResponse = sendControllerSetCredentialsWithHttpInfo(walletId = walletId, presentationRequestSetCredentialsRequestModelDto = presentationRequestSetCredentialsRequestModelDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PresentationRequestSetCredentialsResponseModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Set the credentials to be presented
     * Set the credentials to be presented as part of this presentation response.  Each credential must be linked to an input descriptor from the credential definition. For credentials that support selective disclosure, there is the possibility to use the &#x60;claims_to_disclose&#x60; property. Use object notation to specify which claims to disclose. For example:  &#x60;&#x60;&#x60; \&quot;claims_to_disclose\&quot;: [\&quot;given_name\&quot;, \&quot;address.street_address\&quot;, \&quot;address.locality\&quot;, \&quot;nationalities[0]\&quot;] &#x60;&#x60;&#x60;  If a claim or a nested claim is not found in the credential or it doesn&#39;t support selective disclosure, it will be ignored.  By default, the key ID linked to the credential is used to sign the presentation. The &#x60;kid&#x60; property can be used to specify another key ID. If no key ID is linked to the credential and none is specified, no signature is added to the presentation. 
     * @param walletId 
     * @param presentationRequestSetCredentialsRequestModelDto 
     * @return ApiResponse<PresentationRequestSetCredentialsResponseModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun sendControllerSetCredentialsWithHttpInfo(walletId: kotlin.String, presentationRequestSetCredentialsRequestModelDto: PresentationRequestSetCredentialsRequestModelDto) : ApiResponse<PresentationRequestSetCredentialsResponseModelDto?> {
        val localVariableConfig = sendControllerSetCredentialsRequestConfig(walletId = walletId, presentationRequestSetCredentialsRequestModelDto = presentationRequestSetCredentialsRequestModelDto)

        return request<PresentationRequestSetCredentialsRequestModelDto, PresentationRequestSetCredentialsResponseModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation sendControllerSetCredentials
     *
     * @param walletId 
     * @param presentationRequestSetCredentialsRequestModelDto 
     * @return RequestConfig
     */
    fun sendControllerSetCredentialsRequestConfig(walletId: kotlin.String, presentationRequestSetCredentialsRequestModelDto: PresentationRequestSetCredentialsRequestModelDto) : RequestConfig<PresentationRequestSetCredentialsRequestModelDto> {
        val localVariableBody = presentationRequestSetCredentialsRequestModelDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/send/set_credentials".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

    /**
     * Submit the presentation response to the verifier
     * Generate the presentation response to present the credentials to the verifier.  Based on the &#x60;response_type&#x60;, the following parameters are included in the response:  The response always includes: - &#x60;vp_token&#x60;: A single JSON string or array of JSON strings representing the presentation. - &#x60;presentation_submission&#x60;: A JSON object containing the mapping between the requested credentials and where to find them in the returned VP token. This follows the DIF Presentation Exchange specification.  Optionally, the following is also included: - &#x60;id_token&#x60;: A single JSON string that proves control of the wallet over key material.  Depending on the &#x60;response_mode&#x60; option, the response can be sent to the verifier using an HTTPS POST request or an HTTP redirect.  In case of &#x60;response_mode&#x3D;fragment&#x60; (default), the response is sent via the front channel by opening the &#x60;redirect_uri&#x60;, which is returned in the response to this request. This &#x60;redirect_uri&#x60; includes all the response parameters. Note that this is currently not supported.  In case of &#x60;response_mode&#x3D;direct_post&#x60; or &#x60;response_mode&#x3D;post&#x60;, the response is submitted via an HTTPS POST request to the &#x60;response_uri&#x60;. In this case, it is expected that a &#x60;redirect_uri&#x60; is returned in the response to this request. This &#x60;redirect_uri&#x60; is also to be opened in the front channel, but is simply used to continue the verification process and not to transmit the response to the verifier.  The status of this submission can be tracked via the &#x60;meta.submission_status&#x60; attribute. Note that in case of &#x60;response_mode&#x3D;fragment&#x60;, the status is always &#x60;success&#x60;. 
     * @param walletId 
     * @param presentationRequestSubmitRequestModelDto 
     * @return PresentationRequestSubmitResponseModelDto
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun sendControllerSubmit(walletId: kotlin.String, presentationRequestSubmitRequestModelDto: PresentationRequestSubmitRequestModelDto) : PresentationRequestSubmitResponseModelDto {
        val localVarResponse = sendControllerSubmitWithHttpInfo(walletId = walletId, presentationRequestSubmitRequestModelDto = presentationRequestSubmitRequestModelDto)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as PresentationRequestSubmitResponseModelDto
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * Submit the presentation response to the verifier
     * Generate the presentation response to present the credentials to the verifier.  Based on the &#x60;response_type&#x60;, the following parameters are included in the response:  The response always includes: - &#x60;vp_token&#x60;: A single JSON string or array of JSON strings representing the presentation. - &#x60;presentation_submission&#x60;: A JSON object containing the mapping between the requested credentials and where to find them in the returned VP token. This follows the DIF Presentation Exchange specification.  Optionally, the following is also included: - &#x60;id_token&#x60;: A single JSON string that proves control of the wallet over key material.  Depending on the &#x60;response_mode&#x60; option, the response can be sent to the verifier using an HTTPS POST request or an HTTP redirect.  In case of &#x60;response_mode&#x3D;fragment&#x60; (default), the response is sent via the front channel by opening the &#x60;redirect_uri&#x60;, which is returned in the response to this request. This &#x60;redirect_uri&#x60; includes all the response parameters. Note that this is currently not supported.  In case of &#x60;response_mode&#x3D;direct_post&#x60; or &#x60;response_mode&#x3D;post&#x60;, the response is submitted via an HTTPS POST request to the &#x60;response_uri&#x60;. In this case, it is expected that a &#x60;redirect_uri&#x60; is returned in the response to this request. This &#x60;redirect_uri&#x60; is also to be opened in the front channel, but is simply used to continue the verification process and not to transmit the response to the verifier.  The status of this submission can be tracked via the &#x60;meta.submission_status&#x60; attribute. Note that in case of &#x60;response_mode&#x3D;fragment&#x60;, the status is always &#x60;success&#x60;. 
     * @param walletId 
     * @param presentationRequestSubmitRequestModelDto 
     * @return ApiResponse<PresentationRequestSubmitResponseModelDto?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun sendControllerSubmitWithHttpInfo(walletId: kotlin.String, presentationRequestSubmitRequestModelDto: PresentationRequestSubmitRequestModelDto) : ApiResponse<PresentationRequestSubmitResponseModelDto?> {
        val localVariableConfig = sendControllerSubmitRequestConfig(walletId = walletId, presentationRequestSubmitRequestModelDto = presentationRequestSubmitRequestModelDto)

        return request<PresentationRequestSubmitRequestModelDto, PresentationRequestSubmitResponseModelDto>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation sendControllerSubmit
     *
     * @param walletId 
     * @param presentationRequestSubmitRequestModelDto 
     * @return RequestConfig
     */
    fun sendControllerSubmitRequestConfig(walletId: kotlin.String, presentationRequestSubmitRequestModelDto: PresentationRequestSubmitRequestModelDto) : RequestConfig<PresentationRequestSubmitRequestModelDto> {
        val localVariableBody = presentationRequestSubmitRequestModelDto
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        localVariableHeaders["Accept"] = "application/json"

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/wallets/{walletId}/send/submit".replace("{"+"walletId"+"}", encodeURIComponent(walletId.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
