package me.martiii.simplenetprotocolserver.net;

import me.martiii.simplenetprotocolserver.SimpleNetProtocolServer;

import javax.net.ServerSocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public class NetListener extends Thread {
    private SimpleNetProtocolServer server;
    private volatile boolean closed = false;
    private int port;

    public NetListener(SimpleNetProtocolServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        ServerSocketFactory factory = ServerSocketFactory.getDefault();
        try {
            serverSocket = factory.createServerSocket(port);
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (serverSocket != null) {
            System.out.println("Listening on port " + port + "...");
            while (!closed) {
                try {
                    Socket socket = serverSocket.accept();
                    if (socket != null) {
                        new RequestThread(socket).start();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class RequestThread extends Thread {
        private Socket socket;

        public RequestThread(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                System.out.println("New connection from " + socket.getInetAddress());
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String received = in.readLine();
                System.out.println("Received: " + received);
                server.getProtocolManager().handleRequest(received, socket);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void close() {
        System.out.println("Closing net listener...");
        closed = true;
    }
}
