package me.martiii.simplenetprotocolserver;

import me.martiii.simplenetprotocolserver.net.NetListener;
import me.martiii.simplenetprotocolserver.protocol.ProtocolManager;

public class SimpleNetProtocolServer {
    private NetListener netListener;
    private ProtocolManager protocolManager;

    public SimpleNetProtocolServer() {
        netListener = new NetListener(this);
        protocolManager = new ProtocolManager(this);
    }

    public ProtocolManager getProtocolManager() {
        return protocolManager;
    }

    public void bind(int port) {
        netListener.setPort(port);
        netListener.start();
    }

    public void registerListener(Object listener) {
        protocolManager.registerListener(listener);
    }

    public void stop() {
        netListener.close();
    }
}
