/*
 * Decompiled with CFR 0.152.
 */
package me.martiii.modbustcpjava.protocol.responses;

import me.martiii.modbustcpjava.protocol.ModbusResponse;

public class ReadResponse {
    private int numberBytes;
    private byte[] valuesData;

    public ReadResponse(ModbusResponse response) {
        byte[] data = response.getData();
        this.numberBytes = data[0] & 0xFF;
        this.valuesData = new byte[data.length - 1];
        System.arraycopy(data, 1, this.valuesData, 0, data.length - 1);
    }

    public int getNumberRegisters() {
        return this.numberBytes / 2;
    }

    public int[] getUnsignedRegisters() {
        int[] registers = new int[this.getNumberRegisters()];
        for (int i = 0; i < this.getNumberRegisters(); ++i) {
            registers[i] = (this.valuesData[i * 2] & 0xFF) << 8 | this.valuesData[i * 2 + 1] & 0xFF;
        }
        return registers;
    }

    public int[] getRegisters() {
        int[] registers = new int[this.getNumberRegisters()];
        for (int i = 0; i < this.getNumberRegisters(); ++i) {
            registers[i] = this.valuesData[i * 2] << 8 | this.valuesData[i * 2 + 1] & 0xFF;
        }
        return registers;
    }

    public int getNumberCoils() {
        return this.numberBytes * 8;
    }

    public boolean[] getCoils() {
        boolean[] coils = new boolean[this.getNumberCoils()];
        for (int i = 0; i < this.numberBytes; ++i) {
            for (int b = 0; b < 8; ++b) {
                coils[i * 8 + b] = (this.valuesData[i] & (byte)Math.pow(2.0, b)) != 0;
            }
        }
        return coils;
    }
}

