/*
 * Decompiled with CFR 0.152.
 */
package me.martiii.modbustcpjava.net;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.martiii.modbustcpjava.net.Task;
import me.martiii.modbustcpjava.protocol.ModbusHeader;
import me.martiii.modbustcpjava.protocol.ModbusRequest;
import me.martiii.modbustcpjava.protocol.ModbusResponse;
import me.martiii.simplenethandler.SimpleNetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetHandler
extends SimpleNetHandler {
    private final Logger logger = LoggerFactory.getLogger((String)"ModbusTCPJava");
    private static int lastTransactionID = 0;
    private HashMap<Integer, Task> taskIDs = new HashMap();
    private final List<Thread> retryThreads = new ArrayList<Thread>();

    public NetHandler() {
        this.setPort(502);
        this.setCloseSocketIfDeactivated(false);
    }

    public void setSlaveAddress(String slaveAddress) {
        this.setAddress(slaveAddress);
    }

    public void setSlavePort(int slavePort) {
        this.setPort(slavePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(final Task task, final int retryTimeout) {
        if (this.closed) {
            return;
        }
        final int transID = ++lastTransactionID;
        this.taskIDs.put(transID, task);
        if (lastTransactionID == 65535) {
            lastTransactionID = 0;
        }
        ModbusHeader header = task.getHeader();
        ModbusRequest request = task.getRequest();
        final byte[] frame = new byte[8 + request.getData().length];
        frame[0] = (byte)(transID >>> 8);
        frame[1] = (byte)transID;
        int protocolID = header.getProtocolIdentifier();
        frame[2] = (byte)(protocolID >>> 8);
        frame[3] = (byte)protocolID;
        int length = 2 + request.getData().length;
        frame[4] = (byte)(length >>> 8);
        frame[5] = (byte)length;
        frame[6] = header.getUnitIdentifier();
        frame[7] = request.getFunctionCode();
        System.arraycopy(request.getData(), 0, frame, 8, request.getData().length);
        this.logger.debug("Writing task with id {}: {}", (Object)transID, (Object)task);
        Thread retryThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetHandler.this.write(frame);
                try {
                    Thread.sleep(retryTimeout);
                }
                catch (InterruptedException e) {
                    NetHandler.this.logger.debug("Retry thread interrupted");
                }
                if (NetHandler.this.taskIDs.containsValue(task) && (!NetHandler.this.closed || NetHandler.this.active)) {
                    NetHandler.this.logger.debug("Retrying task with id {}", (Object)transID);
                    this.run();
                } else {
                    List list = NetHandler.this.retryThreads;
                    synchronized (list) {
                        NetHandler.this.retryThreads.remove(this);
                    }
                }
            }
        };
        List<Thread> list = this.retryThreads;
        synchronized (list) {
            this.retryThreads.add(retryThread);
        }
        retryThread.start();
        this.activate();
    }

    public void cancelPendingRequests() {
        this.logger.debug("Cancelling pending requests");
        this.taskIDs.clear();
        this.deactivate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean read(InputStream inputStream) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        byte[] frame = new byte[8];
        int read = dataInputStream.read(frame);
        if (read != 8) throw new Exception("Invalid reading length");
        int transID = (frame[0] & 0xFF) << 8 | frame[1] & 0xFF;
        int protocolID = (frame[2] & 0xFF) << 8 | frame[3] & 0xFF;
        int length = (frame[4] & 0xFF) << 8 | frame[5] & 0xFF;
        byte unitID = frame[6];
        byte functionCode = frame[7];
        byte[] data = new byte[length - 2];
        read = dataInputStream.read(data);
        if (read != length - 2) throw new Exception("Invalid reading length");
        if (!this.taskIDs.containsKey(transID)) return this.taskIDs.isEmpty();
        Task task = this.taskIDs.remove(transID);
        ModbusResponse response = new ModbusResponse(functionCode, data, functionCode != task.getRequest().getFunctionCode());
        this.logger.debug("Response for task with id {}: {}", (Object)transID, (Object)response);
        task.getCallback().callback(response);
        return this.taskIDs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) {
        if (force) {
            List<Thread> list = this.retryThreads;
            synchronized (list) {
                this.retryThreads.forEach(Thread::interrupt);
            }
        }
        super.close(force);
    }
}

