/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.application.dao;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoDTO;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoSaveDTO;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoUpdateDTO;
import org.liuxp.minioplus.api.model.vo.FileMetadataInfoVo;
import org.liuxp.minioplus.application.entity.FileMetadataInfoEntity;
import org.liuxp.minioplus.application.mapper.FileMetadataInfoMapper;
import org.liuxp.minioplus.core.repository.MetadataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MetadataRepositoryImpl
extends ServiceImpl<FileMetadataInfoMapper, FileMetadataInfoEntity>
implements MetadataRepository {
    private static final Logger log = LoggerFactory.getLogger(MetadataRepositoryImpl.class);

    public List<FileMetadataInfoVo> list(FileMetadataInfoDTO searchDTO) {
        QueryWrapper<FileMetadataInfoEntity> queryWrapper = this.buildParams(searchDTO);
        List fileMetadataInfoEntityList = super.list(queryWrapper);
        ArrayList<FileMetadataInfoVo> fileMetadataInfoVoList = new ArrayList<FileMetadataInfoVo>();
        for (FileMetadataInfoEntity fileMetadataInfoEntity : fileMetadataInfoEntityList) {
            FileMetadataInfoVo fileMetadataInfoVo = new FileMetadataInfoVo();
            BeanUtils.copyProperties((Object)fileMetadataInfoEntity, (Object)fileMetadataInfoVo);
            fileMetadataInfoVoList.add(fileMetadataInfoVo);
        }
        return fileMetadataInfoVoList;
    }

    public FileMetadataInfoVo one(FileMetadataInfoDTO searchDTO) {
        QueryWrapper<FileMetadataInfoEntity> queryWrapper = this.buildParams(searchDTO);
        queryWrapper.last("limit 1");
        FileMetadataInfoEntity fileMetadataInfoEntity = (FileMetadataInfoEntity)super.getOne(queryWrapper);
        FileMetadataInfoVo fileMetadataInfoVo = new FileMetadataInfoVo();
        if (null != fileMetadataInfoEntity) {
            BeanUtils.copyProperties((Object)fileMetadataInfoEntity, (Object)fileMetadataInfoVo);
        }
        return fileMetadataInfoVo;
    }

    public FileMetadataInfoVo save(FileMetadataInfoSaveDTO saveDTO) {
        FileMetadataInfoEntity fileMetadataInfoEntity = new FileMetadataInfoEntity();
        BeanUtils.copyProperties((Object)saveDTO, (Object)fileMetadataInfoEntity);
        fileMetadataInfoEntity.setCreateTime(new Date());
        fileMetadataInfoEntity.setUpdateTime(new Date());
        boolean result = super.save((Object)fileMetadataInfoEntity);
        FileMetadataInfoVo fileMetadataInfoVo = new FileMetadataInfoVo();
        if (result) {
            BeanUtils.copyProperties((Object)fileMetadataInfoEntity, (Object)fileMetadataInfoVo);
        }
        return fileMetadataInfoVo;
    }

    public FileMetadataInfoVo update(FileMetadataInfoUpdateDTO updateDTO) {
        FileMetadataInfoEntity fileMetadataInfoEntity = new FileMetadataInfoEntity();
        BeanUtils.copyProperties((Object)updateDTO, (Object)fileMetadataInfoEntity);
        fileMetadataInfoEntity.setUpdateTime(new Date());
        boolean result = super.updateById((Object)fileMetadataInfoEntity);
        FileMetadataInfoVo fileMetadataInfoVo = new FileMetadataInfoVo();
        if (result) {
            BeanUtils.copyProperties((Object)fileMetadataInfoEntity, (Object)fileMetadataInfoVo);
        }
        return fileMetadataInfoVo;
    }

    public Boolean remove(Long id) {
        return super.removeById((Serializable)id);
    }

    private QueryWrapper<FileMetadataInfoEntity> buildParams(FileMetadataInfoDTO searchDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(CharSequenceUtil.isNotBlank((CharSequence)searchDTO.getFileKey()), (Object)"file_key", (Object)searchDTO.getFileKey());
        queryWrapper.eq(CharSequenceUtil.isNotBlank((CharSequence)searchDTO.getFileMd5()), (Object)"file_md5", (Object)searchDTO.getFileMd5());
        queryWrapper.eq(CharSequenceUtil.isNotBlank((CharSequence)searchDTO.getBucket()), (Object)"bucket", (Object)searchDTO.getBucket());
        queryWrapper.eq(null != searchDTO.getIsPrivate(), (Object)"is_private", (Object)searchDTO.getIsPrivate());
        queryWrapper.eq(CharSequenceUtil.isNotBlank((CharSequence)searchDTO.getCreateUser()), (Object)"create_user", (Object)searchDTO.getCreateUser());
        return queryWrapper;
    }
}

