/*
 * Decompiled with CFR 0.152.
 */
package me.liuwj.ktorm.support.sqlite;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import me.liuwj.ktorm.database.CachedRowSet;
import me.liuwj.ktorm.database.Database;
import me.liuwj.ktorm.database.JdbcExtensionsKt;
import me.liuwj.ktorm.database.SqlDialect;
import me.liuwj.ktorm.database.Transaction;
import me.liuwj.ktorm.expression.ArgumentExpression;
import me.liuwj.ktorm.expression.SqlFormatter;
import me.liuwj.ktorm.logging.Logger;
import me.liuwj.ktorm.support.sqlite.SQLiteFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J6\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lme/liuwj/ktorm/support/sqlite/SQLiteDialect;", "Lme/liuwj/ktorm/database/SqlDialect;", "()V", "createSqlFormatter", "Lme/liuwj/ktorm/expression/SqlFormatter;", "database", "Lme/liuwj/ktorm/database/Database;", "beautifySql", "", "indentSize", "", "executeUpdateAndRetrieveKeys", "Lkotlin/Pair;", "Lme/liuwj/ktorm/database/CachedRowSet;", "sql", "", "args", "", "Lme/liuwj/ktorm/expression/ArgumentExpression;", "ktorm-support-sqlite"})
public class SQLiteDialect
implements SqlDialect {
    @NotNull
    public SqlFormatter createSqlFormatter(@NotNull Database database, boolean beautifySql, int indentSize) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new SQLiteFormatter(database, beautifySql, indentSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Pair<Integer, CachedRowSet> executeUpdateAndRetrieveKeys(@NotNull Database database, @NotNull String sql, @NotNull List<? extends ArgumentExpression<?>> args) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Database this_$iv = database;
        boolean $i$f$useConnection = false;
        boolean bl = false;
        try {
            Transaction transaction$iv = this_$iv.getTransactionManager().getCurrentTransaction();
            Object object = transaction$iv;
            if (object == null || (object = object.getConnection()) == null) {
                object = this_$iv.getTransactionManager().newConnection();
            }
            Object connection$iv = object;
            try {
                CachedRowSet cachedRowSet;
                Object conn = connection$iv;
                boolean bl2 = false;
                AutoCloseable $this$use$iv = conn.prepareStatement(sql);
                boolean $i$f$use = false;
                int n = 0;
                try {
                    PreparedStatement statement = (PreparedStatement)$this$use$iv;
                    boolean bl3 = false;
                    PreparedStatement preparedStatement = statement;
                    Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"statement");
                    JdbcExtensionsKt.setArguments((PreparedStatement)preparedStatement, args);
                    n = statement.executeUpdate();
                }
                finally {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                int effects = n;
                String retrieveKeySql = "select last_insert_rowid()";
                if (database.getLogger().isDebugEnabled()) {
                    Logger.DefaultImpls.debug$default((Logger)database.getLogger(), (String)("Retrieving generated keys by SQL: " + retrieveKeySql), null, (int)2, null);
                }
                AutoCloseable $this$use$iv2 = conn.prepareStatement(retrieveKeySql);
                boolean $i$f$use2 = false;
                boolean bl4 = false;
                try {
                    CachedRowSet cachedRowSet2;
                    PreparedStatement statement = (PreparedStatement)$this$use$iv2;
                    boolean bl5 = false;
                    AutoCloseable $this$use$iv3 = statement.executeQuery();
                    boolean $i$f$use3 = false;
                    boolean bl6 = false;
                    try {
                        ResultSet rs = (ResultSet)$this$use$iv3;
                        boolean bl7 = false;
                        ResultSet resultSet = rs;
                        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"rs");
                        cachedRowSet2 = new CachedRowSet(resultSet);
                    }
                    finally {
                        AutoCloseable autoCloseable = $this$use$iv3;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    cachedRowSet = cachedRowSet2;
                }
                finally {
                    AutoCloseable autoCloseable = $this$use$iv2;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                CachedRowSet rowSet = cachedRowSet;
                Pair pair = new Pair((Object)effects, (Object)rowSet);
                return pair;
            }
            finally {
                if (transaction$iv == null) {
                    connection$iv.close();
                }
            }
        }
        catch (SQLException e$iv) {
            Object object = this_$iv.getExceptionTranslator();
            if (object == null || (object = (Throwable)object.invoke((Object)e$iv)) == null) {
                object = e$iv;
            }
            throw object;
        }
    }
}

