/*
 * Decompiled with CFR 0.152.
 */
package me.kisoft.easybus.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import me.kisoft.easybus.EventHandler;
import me.kisoft.easybus.mongodb.MongodbEvent;
import org.jongo.Jongo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbCollectionPollRunnable
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(MongodbCollectionPollRunnable.class);
    private final EventHandler handler;
    private final Jongo jongo;
    private final ObjectMapper mapper = new ObjectMapper();

    public MongodbCollectionPollRunnable(EventHandler handler, Jongo jongo) {
        if (handler == null) {
            throw new IllegalArgumentException("Attempting to start runnable with null handler");
        }
        if (jongo == null) {
            throw new IllegalArgumentException("Attempting to start runnable with null jongo");
        }
        this.handler = handler;
        this.jongo = jongo;
    }

    @Override
    public void run() {
        try {
            MongodbEvent event = (MongodbEvent)this.jongo.getCollection(this.handler.getEventClassName()).findAndModify("{processing:false,handled:false}").sort("{lastAccess:1}").with("{$set:{processing:true,lastAccess:#}}", new Object[]{new Date()}).as(MongodbEvent.class);
            if (event != null) {
                Object data = this.mapper.convertValue((Object)event.getData(), this.handler.getEventClass());
                try {
                    this.handler.handle(data);
                    event = (MongodbEvent)this.jongo.getCollection(this.handler.getEventClassName()).findAndModify("{eventId:#}", new Object[]{event.getEventId()}).with("{$set:{processing:false,handled:true,lastAccess:#}}", new Object[]{new Date()}).as(MongodbEvent.class);
                }
                catch (RuntimeException ex) {
                    this.log.debug(ex.getMessage());
                    event = (MongodbEvent)this.jongo.getCollection(this.handler.getEventClassName()).findAndModify("{eventId:#}", new Object[]{event.getEventId()}).with("{$set:{processing:false,handled:false,lastAccess:#}}", new Object[]{new Date()}).as(MongodbEvent.class);
                    this.log.debug(String.format("Re-Submitting event with id : %s", event.getEventId()));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            this.log.error(ex.getMessage());
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof MongodbCollectionPollRunnable) {
            MongodbCollectionPollRunnable casted = (MongodbCollectionPollRunnable)other;
            return this.handler.equals((Object)casted.handler) && this.jongo.equals(casted.jongo);
        }
        return false;
    }

    public int hashCode() {
        return this.handler.hashCode();
    }
}

