/*
 * Decompiled with CFR 0.152.
 */
package me.kisoft.easybus.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.kisoft.easybus.Bus;
import me.kisoft.easybus.EventHandler;
import me.kisoft.easybus.mongodb.MongodbCollectionPollRunnable;
import me.kisoft.easybus.mongodb.MongodbEvent;
import org.jongo.Jongo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbBusImpl
implements Bus {
    private final Logger log = LoggerFactory.getLogger(MongodbBusImpl.class);
    private final ScheduledExecutorService pool;
    private final long pollTime;
    private final Map<EventHandler, ScheduledFuture> futureMap = new HashMap<EventHandler, ScheduledFuture>();
    private final Jongo jongo;
    ObjectMapper mapper = new ObjectMapper();

    public MongodbBusImpl() {
        this.pool = Executors.newScheduledThreadPool(15);
        this.pollTime = 10L;
        this.jongo = null;
    }

    public MongodbBusImpl(Jongo jongo, int numberOfThreads, long pollTime) {
        this.pool = Executors.newScheduledThreadPool(numberOfThreads);
        this.pollTime = pollTime;
        this.jongo = jongo;
    }

    public MongodbBusImpl(Jongo jongo) {
        this.pool = Executors.newScheduledThreadPool(15);
        this.pollTime = 10L;
        this.jongo = jongo;
    }

    public void post(Object object) {
        MongodbEvent event = new MongodbEvent((Map)this.mapper.convertValue(object, Map.class));
        this.jongo.getCollection(object.getClass().getCanonicalName()).save((Object)event);
    }

    public void clear() {
        this.futureMap.values().stream().forEach(future -> future.cancel(false));
        this.futureMap.clear();
    }

    public void addHandler(EventHandler handler) {
        ScheduledFuture<?> future = this.pool.scheduleAtFixedRate(new MongodbCollectionPollRunnable(handler, this.jongo), 0L, this.pollTime, TimeUnit.MILLISECONDS);
        this.futureMap.put(handler, future);
    }

    public void removeHandler(EventHandler handler) {
        ScheduledFuture future = this.futureMap.get(handler);
        if (future != null) {
            future.cancel(false);
            this.futureMap.remove(handler);
        }
    }
}

