/*
 * Decompiled with CFR 0.152.
 */
package me.kisoft.easybus.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.kisoft.easybus.EventHandler;
import me.kisoft.easybus.mongodb.MongodbEvent;
import org.jongo.Jongo;

public class MongodbCollectionPollRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(MongodbCollectionPollRunnable.class.getName());
    private final EventHandler handler;
    private final Jongo jongo;
    private final ObjectMapper mapper = new ObjectMapper();

    public MongodbCollectionPollRunnable(EventHandler handler, Jongo jongo) {
        if (handler == null) {
            throw new IllegalArgumentException("Attempting to start runnable with null handler");
        }
        if (jongo == null) {
            throw new IllegalArgumentException("Attempting to start runnable with null jongo");
        }
        this.handler = handler;
        this.jongo = jongo;
    }

    @Override
    public void run() {
        try {
            MongodbEvent event = (MongodbEvent)this.jongo.getCollection(this.handler.getEventClassName()).findAndModify("{processing:false,handled:false}").sort("{lastAccess:1}").with("{$set:{processing:true,lastAccess:#}}", new Object[]{new Date()}).as(MongodbEvent.class);
            if (event != null) {
                Object data = this.mapper.convertValue((Object)event.getData(), this.handler.getEventClass());
                try {
                    this.handler.handle(data);
                    event = (MongodbEvent)this.jongo.getCollection(this.handler.getEventClassName()).findAndModify("{eventId:#}", new Object[]{event.getEventId()}).with("{$set:{processing:false,handled:true,lastAccess:#}}", new Object[]{new Date()}).as(MongodbEvent.class);
                }
                catch (RuntimeException ex) {
                    log.fine(ex.getMessage());
                    event = (MongodbEvent)this.jongo.getCollection(this.handler.getEventClassName()).findAndModify("{eventId:#}", new Object[]{event.getEventId()}).with("{$set:{processing:false,handled:false,lastAccess:#}}", new Object[]{new Date()}).as(MongodbEvent.class);
                    log.log(Level.FINE, "Re-Submitting event with id : {0}", event.getEventId());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            log.severe(ex.getMessage());
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof MongodbCollectionPollRunnable) {
            MongodbCollectionPollRunnable casted = (MongodbCollectionPollRunnable)other;
            return this.handler.equals((Object)casted.handler) && this.jongo.equals(casted.jongo);
        }
        return false;
    }

    public int hashCode() {
        return this.handler.hashCode();
    }
}

