/*
 * Decompiled with CFR 0.152.
 */
package me.julb.sdk.github.actions.kit;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.NonNull;
import me.julb.sdk.github.actions.kit.AnnotationProperties;
import me.julb.sdk.github.actions.kit.ExecCommand;
import me.julb.sdk.github.actions.kit.SystemProxy;
import me.julb.sdk.github.actions.kit.SystemProxySystemImpl;

public class GitHubActionsKit {
    public static final GitHubActionsKit INSTANCE = new GitHubActionsKit(new SystemProxySystemImpl());
    private final SystemProxy systemProxy;

    public Optional<String> getInput(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getInput(name, true);
    }

    public Optional<String> getInput(@NonNull String name, boolean trimValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String inputEnvProperty = "INPUT_" + name.replaceAll("\\s", "_").toUpperCase();
        return this.getEnv(inputEnvProperty).map(v -> {
            if (trimValue) {
                return v.trim();
            }
            return v;
        });
    }

    public String getRequiredInput(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getInput(name).orElseThrow();
    }

    public String getRequiredInput(@NonNull String name, boolean trimValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getInput(name, trimValue).orElseThrow();
    }

    public Optional<Boolean> getBooleanInput(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getInput(name, true).map(s -> {
            String sUpperCase = s.toLowerCase();
            if (Boolean.TRUE.toString().equals(sUpperCase)) {
                return true;
            }
            if (Boolean.FALSE.toString().equals(sUpperCase)) {
                return false;
            }
            throw new IllegalArgumentException((String)s);
        });
    }

    public Boolean getRequiredBooleanInput(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getBooleanInput(name).orElseThrow();
    }

    public <T extends Enum<T>> Optional<T> getEnumInput(@NonNull String name, Class<T> enumClass) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getInput(name, true).map(s -> {
            String sUpperCase = s.toUpperCase();
            return Enum.valueOf(enumClass, sUpperCase);
        });
    }

    public <T extends Enum<T>> T getRequiredEnumInput(@NonNull String name, Class<T> enumClass) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return (T)((Enum)this.getEnumInput(name, enumClass).orElseThrow());
    }

    public Optional<String[]> getMultilineInput(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getMultilineInput(name, true);
    }

    public Optional<String[]> getMultilineInput(@NonNull String name, boolean trimValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getInput(name, trimValue).map(String::lines).map(stream -> (String[])stream.map(s -> trimValue ? s.trim() : s).filter(s -> !s.isBlank()).toArray(String[]::new));
    }

    public String[] getRequiredMultilineInput(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getMultilineInput(name).orElseThrow();
    }

    public String[] getRequiredMultilineInput(@NonNull String name, boolean trimValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getMultilineInput(name, trimValue).orElseThrow();
    }

    public <T> void setOutput(@NonNull String name, @NonNull T value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.issue("set-output", Map.of("name", name), value);
    }

    public void setCommandEcho(boolean enabled) {
        this.issue("echo", enabled ? "on" : "off");
    }

    public void startGroup(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.issue("group", name);
    }

    public void group(@NonNull String name, @NonNull Runnable exec) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (exec == null) {
            throw new NullPointerException("exec is marked non-null but is null");
        }
        this.startGroup(name);
        try {
            exec.run();
        }
        finally {
            this.endGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T group(@NonNull String name, @NonNull Callable<T> exec) throws Exception {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (exec == null) {
            throw new NullPointerException("exec is marked non-null but is null");
        }
        this.startGroup(name);
        try {
            T t = exec.call();
            return t;
        }
        finally {
            this.endGroup();
        }
    }

    public void endGroup() {
        this.issue("endgroup");
    }

    public <T> void saveState(@NonNull String name, @NonNull T value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.issue("save-state", Map.of("name", name), value);
    }

    public Optional<String> getState(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String stateEnvProperty = "STATE_" + name.replaceAll("\\s", "_").toUpperCase();
        return this.getEnv(stateEnvProperty);
    }

    public <T> void setSecret(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.issue("add-mask", value);
    }

    public boolean isDebug() {
        return this.getEnv("RUNNER_DEBUG").map(v -> v.equals("1")).orElse(false);
    }

    public void debug(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.issue("debug", message);
    }

    public void notice(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.notice(message, Optional.empty());
    }

    public void notice(@NonNull String message, @NonNull Optional<AnnotationProperties> properties) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.issue("notice", properties.map(AnnotationProperties::toMap).orElse(Map.of()), message);
    }

    public void warning(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.warning(message, Optional.empty());
    }

    public void warning(@NonNull String message, @NonNull Optional<AnnotationProperties> properties) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.issue("warning", properties.map(AnnotationProperties::toMap).orElse(Map.of()), message);
    }

    public void error(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.error(message, Optional.empty());
    }

    public void error(@NonNull String message, @NonNull Optional<AnnotationProperties> properties) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.issue("error", properties.map(AnnotationProperties::toMap).orElse(Map.of()), message);
    }

    public void fail(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.error(message);
        this.systemProxy.exit(1);
    }

    public String getGitHubRepository() {
        return this.getEnv("GITHUB_REPOSITORY").orElseThrow();
    }

    public String getGitHubRefType() {
        return this.getEnv("GITHUB_REF_TYPE").orElseThrow();
    }

    public boolean isGitHubRefTypeBranch() {
        return this.getGitHubRefType().equalsIgnoreCase("branch");
    }

    public boolean isGitHubRefTypeTag() {
        return this.getGitHubRefType().equalsIgnoreCase("tag");
    }

    public String getGitHubRef() {
        return this.getEnv("GITHUB_REF").orElseThrow();
    }

    public String getGitHubRefName() {
        return this.getEnv("GITHUB_REF_NAME").orElseThrow();
    }

    public String getGitHubSha() {
        return this.getEnv("GITHUB_SHA").orElseThrow();
    }

    public String getGitHubAbbreviatedSha() {
        String sha = this.getGitHubSha();
        return sha.substring(0, Math.min(7, sha.length()));
    }

    public String getGitHubRunId() {
        return this.getEnv("GITHUB_RUN_ID").orElseThrow();
    }

    public String getGitHubApiUrl() {
        return this.getEnv("GITHUB_API_URL").orElseThrow();
    }

    public Optional<String> getEnv(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Optional.ofNullable(this.systemProxy.getenv(name));
    }

    public String getRequiredEnv(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.getEnv(name).orElseThrow();
    }

    private void issue(String command) {
        this.issueCommand(command, Optional.empty(), Optional.empty());
    }

    private <M> void issue(String command, M message) {
        this.issueCommand(command, Optional.empty(), Optional.of(message));
    }

    private <P, M> void issue(String command, Map<String, P> properties, M message) {
        this.issueCommand(command, Optional.of(properties), Optional.of(message));
    }

    private <P, M> void issueCommand(String command, Optional<Map<String, P>> properties, Optional<M> message) {
        this.systemProxy.println(new ExecCommand<P, M>(command, properties, message).toString());
    }

    GitHubActionsKit(SystemProxy systemProxy) {
        this.systemProxy = systemProxy;
    }
}

