/*
 * Decompiled with CFR 0.152.
 */
package me.julb.sdk.github.actions.kit;

import java.util.List;
import java.util.Map;
import java.util.Optional;

class ExecCommand<P, M> {
    private static final String CMD_STRING = "::";
    private final String name;
    private final Optional<Map<String, P>> properties;
    private final Optional<M> message;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_STRING);
        sb.append(this.name);
        this.properties.ifPresent(map -> {
            if (!map.isEmpty()) {
                List<String> propertiesAsList = map.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), ExecCommand.escapePropertyValue(Optional.ofNullable(entry.getValue())))).toList();
                sb.append(" ").append(String.join((CharSequence)",", propertiesAsList));
            }
        });
        sb.append(CMD_STRING);
        sb.append(ExecCommand.escapeMessage(this.message));
        return sb.toString();
    }

    private static <T> String escapePropertyValue(Optional<T> propertyValue) {
        return propertyValue.map(Object::toString).orElse("").replace("%", "%25").replace("\r", "%0D").replace("\n", "%0A").replace(":", "%3A").replace(",", "%2C");
    }

    private static <T> String escapeMessage(Optional<T> message) {
        return message.map(Object::toString).orElse("").replace("%", "%25").replace("\r", "%0D").replace("\n", "%0A");
    }

    public ExecCommand(String name, Optional<Map<String, P>> properties, Optional<M> message) {
        this.name = name;
        this.properties = properties;
        this.message = message;
    }
}

