/*
 * Decompiled with CFR 0.152.
 */
package me.julb.sdk.github.actions.kit;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class AnnotationProperties {
    private String title;
    private String file;
    private Integer startLine;
    private Integer endLine;
    private Integer startColumn;
    private Integer endColumn;

    public Map<String, String> toMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("title", this.title);
        map.put("file", this.file);
        map.put("line", Optional.ofNullable(this.startLine).map(Object::toString).orElse(null));
        map.put("endLine", Optional.ofNullable(this.endLine).map(Object::toString).orElse(null));
        map.put("col", Optional.ofNullable(this.startColumn).map(Object::toString).orElse(null));
        map.put("endColumn", Optional.ofNullable(this.endColumn).map(Object::toString).orElse(null));
        return map;
    }

    AnnotationProperties(String title, String file, Integer startLine, Integer endLine, Integer startColumn, Integer endColumn) {
        this.title = title;
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    public static AnnotationPropertiesBuilder builder() {
        return new AnnotationPropertiesBuilder();
    }

    public static class AnnotationPropertiesBuilder {
        private String title;
        private String file;
        private Integer startLine;
        private Integer endLine;
        private Integer startColumn;
        private Integer endColumn;

        AnnotationPropertiesBuilder() {
        }

        public AnnotationPropertiesBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AnnotationPropertiesBuilder file(String file) {
            this.file = file;
            return this;
        }

        public AnnotationPropertiesBuilder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public AnnotationPropertiesBuilder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public AnnotationPropertiesBuilder startColumn(Integer startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public AnnotationPropertiesBuilder endColumn(Integer endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        public AnnotationProperties build() {
            return new AnnotationProperties(this.title, this.file, this.startLine, this.endLine, this.startColumn, this.endColumn);
        }

        public String toString() {
            return "AnnotationProperties.AnnotationPropertiesBuilder(title=" + this.title + ", file=" + this.file + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", startColumn=" + this.startColumn + ", endColumn=" + this.endColumn + ")";
        }
    }
}

