/*
 * Decompiled with CFR 0.152.
 */
package me.jpomykala.starters.springhoc.utils;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static String getClientIP(HttpServletRequest request) {
        String defaultOutput = "UNKNOWN";
        if (request == null) {
            return defaultOutput;
        }
        String xfHeader = request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return request.getRemoteAddr();
        }
        try {
            return xfHeader.split(",")[0];
        }
        catch (Exception e) {
            return defaultOutput;
        }
    }

    public static String getPath(HttpServletRequest request) {
        Optional<HttpServletRequest> optionalRequest = Optional.ofNullable(request);
        String requestUrl = optionalRequest.map(HttpServletRequest::getRequestURL).map(StringBuffer::toString).orElse("<no_path>");
        String queryString = optionalRequest.map(HttpServletRequest::getQueryString).orElse("");
        if (!Strings.isNullOrEmpty((String)queryString)) {
            return requestUrl + "?" + queryString;
        }
        return requestUrl;
    }
}

